
// Tiny MCE
$(function () {

    "use strict";

    var imgLink = null;
    tinymce.init({
        selector: '.tinyMCE',
        language: language,
        convert_urls : (base_url != '' ? true : false),
        relative_urls : false,
        remove_script_host : false,
        document_base_url : base_url,
        object_resizing : true,
        theme: "modern",
        resize: "both",
        fix_list_elements : true,
        image_list: Routing.generate('wi_admin_media_image_list'),
        rel_list: [
            {title: 'Lightbox', value: 'lightbox'},
            {title: 'Canonical', value: 'canonical'},
            {title: 'Nofollow', value: 'nofollow'}
        ],
        content_css: [sciezkaCss],
        image_advtab: true,
        //  plugins: ["style,layer,advhr,advimage,advlink,iespell,inlinepopups,noneditable,xhtmlxtras"],   - tych pluginĂłw nie ma w nowej wersji
        plugins: [
            "advlist autolink image lists charmap print preview hr anchor pagebreak",
            "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
            "save table contextmenu directionality emoticons template paste textcolor link"
        ],
        toolbar1: "insertfile undo redo | styleselect fontsizeselect | bold italic underline | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | webimpulsLink unlink image | print preview media fullpage | forecolor backcolor emoticons | removeformat",
        toolbar2: "webimpulsRWD | webimpulsMedia",
        visualblocks_default_state: true,
        end_container_on_empty_block: true,
        valid_elements: 'video[*],figure[*],aside[*],blockquote[*],article[*],section[*],a[*],abbr[*],acronym[*],address[*],area[*],audio[*],b[*],bdo[*],big[*],blockquote[*],br[*],button[*],caption[*],center[*],cite[*],code[*],col[*],colgroup[*],del[*],dfn[*],dir[*],div[*],dl[*],dd[*],dt[*],em[*],embed[*],fieldset[*],font[*],form[*],h1[*],h2[*],h3[*],h4[*],h5[*],h6[*],hr[*],i[*],iframe[*],img[*],input[*],ins[*],kbd[*],label[*],legend[*],li[*],map[*],menu[*],nobr[*],object[*],ol[*],optgroup[*],option[*],p[*],param[*],pre[*],q[*],s[*],samp[*],script[*],select[*],small[*],source[*],span[*],strike[*],strong[*],sub[*],sup[*],table[*],tbody[*],td[*],textarea[*],tfoot[*],th[*],thead[*],tr[*],tt[*],u[*],ul[*],var[*]',
        extended_valid_elements: 'div*,div[*],i*,i[*]',
        fontsize_formats: '8pt 9pt 10pt 11pt 12pt 13pt 14pt 16pt 18pt 20pt 24pt 36pt',
        style_formats: [
            {title: naglowki, items: [
                {title: 'h1', format: 'h1'},
                {title: 'h2', format: 'h2'},
                {title: 'h3', format: 'h3'},
                {title: 'h4', format: 'h4'},
                {title: 'h5', format: 'h5'}
            ]},
            {title: linki, items: [
                {title: 'Button Large', selector: 'a', classes : 'button large'},
                {title: 'Button (podstawowy)', selector: 'a', classes : 'button'},
                {title: 'Button small', selector: 'a', classes : 'button small'},
                {title: 'Button tiny', selector: 'a', classes : 'button tiny'},
                {title: 'expand', selector: 'a', classes : 'expand'},
                {title: kolory, items: [
                    {title: 'alert', selector: 'a', classes : 'alert'},
                    {title: 'success', selector: 'a', classes : 'success'},
                    {title: 'secondary', selector: 'a', classes : 'secondary'},
                    {title: 'info', selector: 'a', classes : 'info'},
                    {title: 'expand', selector: 'a', classes : 'expand'},
                ]},
                {title: zaokraglenie, items: [
                    {title: 'round', selector: 'a', classes : 'round'},
                    {title: 'radius', selector: 'a', classes : 'radius'},
                ]},
            ]},
            {title: bloki, items: [
                {title: 'p', block: 'p'},
                {title: 'div', block: 'div'},
                {title: 'pre', block: 'pre'},
                {title: 'panel', block: 'div', classes : 'panel'}
            ]},

            {title: kontenery, items: [
                {title: 'section', block: 'section', wrapper: true, merge_siblings: false},
                {title: 'article', block: 'article', wrapper: true, merge_siblings: false},
                {title: 'blockquote', block: 'blockquote', wrapper: true},
                {title: 'aside', block: 'aside', wrapper: true},
                {title: 'figure', block: 'figure', wrapper: true}
            ]},
            {title: interlinia, items: [
                {title: '1', selector: 'p', styles: {'line-height': '100%'}},
                {title: '1,15', selector: 'p', styles: {'line-height': '115%'}},
                {title: '1,5', selector: 'p', styles: {'line-height': '150%'}},
                {title: '2', selector: 'p', styles: {'line-height': '200%'}},
                {title: '2,5', selector: 'p', styles: {'line-height': '250%'}},
                {title: '3', selector: 'p', styles: {'line-height': '300%'}},
            ]},
            {title: padding, items: [
                {title: '1px', selector: 'div', styles: {'padding': '1px'}},
                {title: '5px', selector: 'div', styles: {'padding': '5px'}},
                {title: '10px', selector: 'div', styles: {'padding': '10px'}},
                {title: '20px', selector: 'div', styles: {'padding': '20px'}},

            ]},
            {title: callout, items: [
                {title: 'callout', selector: 'div', classes: 'callout'},
                {title: 'secondary callout', selector: 'div', classes: 'callout secondary'},
                {title: 'primary callout', selector: 'div', classes: 'callout primary'},
                {title: 'callout success', selector: 'div', classes: 'callout success'},
                {title: 'callout warning', selector: 'div', classes: 'callout warning'},
                {title: 'callout alert', selector: 'div', classes: 'callout alert'},
            ]},

        ],

        setup: function (editor) {
            editor.addButton('webimpulsRWD', {
                text: 'Grid RWD',
                onclick: function () {
                    if(tinyMCE) {
                        tinyMCE.execCommand('mceFocus',false, $('.mceEditor:visible').prev().attr('id'));
                    }
                    $('#GridRWDModal').foundation('open');
                },
            });
            editor.addMenuItem('webimpulsLink', {
                text: insertLink,
                icon: 'link',
                context: 'insert',
                onclick: function () {
                    imgLink = addLink(imgLink, editor, tinyMCE);
                },
            });
            editor.addButton('webimpulsLink', {
                text: '',
                icon: 'link',
                tooltip: insertLink,
                onclick: function () {
                    imgLink = addLink(imgLink, editor, tinyMCE);
                },
                onpostrender: function () {
                    var btn = this;
                    editor.on('init', function() {
                        editor.formatter.formatChanged('link', function(state) {
                            btn.active(state);
                        });
                    });
                }
            });
            editor.addButton('webimpulsMedia', {
                text: 'Media library',
                onclick: function () {
                    if(tinyMCE) {
                        tinyMCE.execCommand('mceFocus',false, $('.mceEditor:visible').prev().attr('id'));
                    }
                    var directory = '/';
                    $.ajax({
                        type     : "POST",
                        url      : Routing.generate('wi_admin_media_tinymce_media_view'),
                        data     : {

                        },
                        success: function(ret) {
                            $('#returnAjax').html(ret);
                            var directory = $('#uploaderFile').attr('data-directory');
                            uploadPlikow(directory);
                        },
                        complete: function() {
                            //ten fragment wykona się po zakończeniu łączenia - nie ważne czy wystąpił błąd, czy sukces
                        },
                        error: function(jqXHR, errorText, errorThrown) {
                            //ten fragment wykona się w przypadku BŁĘDU
                        }
                    });
                    $('#mediaModal').foundation('open');
                }
            });

        }

    });

    $('#insertLinkButton').on('click', function () {
        var linkURL = $('#linkURL').val();
        var linkText = (imgLink != null ? imgLink : $('#linkText').val());
        var linkTitle = $('#linkTitle').val();
        var linkRel = $('#linkRel').val();
        var linkGoal = $('#linkGoal').val();
        var classCss = $('#classCss').val();
        //console.log(classCss);
        var linkData = {
            href: linkURL,
            title: linkTitle,
            class: classCss,
        };
        if(linkRel != 'norel'){
            linkData.rel = linkRel;
        }
        imgLink = null;
        if(linkGoal == 'newWindow'){
            linkData.target = '_blank';
        }
        if(linkURL == ''){
            tinymce.activeEditor.selection.setContent(linkText);
        } else {
            tinymce.activeEditor.selection.setNode(tinymce.activeEditor.dom.create('a', linkData, linkText));
        }
       // tinymce.activeEditor.selection.setNode(tinymce.activeEditor.dom.create('a', linkData, linkText));

        $('#linkURL').val('');
        $('#linkText').val('');
        $('#linkTitle').val('');
        $('#classCss').val('');

        $('#linkiModal').foundation('close');
    });
    $('.insertBut').bind('click', function() {
        if(tinyMCE) {
            var wartosc = $(this).attr('id');
            var grid = $('.'+wartosc).html();
            //alert(grid);
            tinyMCE.activeEditor.execCommand('mceInsertContent',false, grid);
            $('#GridRWDModal').foundation('close');
        }
    });
    $('#returnAjax').on('dblclick', '.plikPlik', function () {
        if(tinyMCE) {
            var link = $(this).attr('data-link');
            var alt = $(this).attr('data-filename');
            var images = '<img src="'+link+'" alt="'+alt+'">';
            //alert(grid);
            tinyMCE.activeEditor.execCommand('mceInsertContent',false, images);
            $('#mediaModal').foundation('close');
        }
    });
    $('#returnAjax').on('click', '.insertButtonFileHover', function () {
        if(tinyMCE) {
            var link = $(this).attr('data-link');
            var alt = $(this).attr('data-filename');
            var images = '<img src="'+link+'" alt="'+alt+'">';
            //alert(grid);
            tinyMCE.activeEditor.execCommand('mceInsertContent',false, images);
            $('#mediaModal').foundation('close');
        }
    });
    $('#returnAjax').on('click', '.comeback', function () {
        var directory = $(this).attr('data-directory');
        $.ajax({
            type     : "GET",
            url      : Routing.generate('wi_admin_media_tinymce_media_view'),
            data     : {
                directory: directory,
            },
            success: function(ret) {
                $('#returnAjax').html(ret);
                var directory = $('#uploaderFile').attr('data-directory');
                uploadPlikow(directory);
            },
            complete: function() {
                //ten fragment wykona się po zakończeniu łączenia - nie ważne czy wystąpił błąd, czy sukces
            },
            error: function(jqXHR, errorText, errorThrown) {
                //ten fragment wykona się w przypadku BŁĘDU
            }
        });
    });
    $('#returnAjax').on('click', '.clickMedia', function () {
        var directory = $(this).attr('data-directory');
        $.ajax({
            type     : "GET",
            url      : Routing.generate('wi_admin_media_tinymce_media_view'),
            data     : {
                directory: directory,
            },
            success: function(ret) {
                $('#returnAjax').html(ret);
                var directory = $('#uploaderFile').attr('data-directory');
                uploadPlikow(directory);
            },
            complete: function() {
            },
            error: function(jqXHR, errorText, errorThrown) {
            }
        });
    });

    $('#returnAjax').on('click', '.mediaPlik', function () {
        var nameFile = $(this).attr('data-filename');
        var typeFile = $(this).attr('data-mime-type');
        var urlFile = $(this).attr('data-link');
        var dimensionFile = $(this).attr('data-dimensions');
        var sizeFile = $(this).attr('data-size');
        var dataI = $(this).attr('data-i');

        $('#fileName').text(nameFile);
        $('#fileImg').attr('src', urlFile);
        $('#fileSize').text(sizeFile);
        $('#fileDimensions').text(dimensionFile);
        $('#fileTyp').text(typeFile);
        $('#fileUrl').val(urlFile);
        $('#downloadButton').attr('href', urlFile).attr('download', nameFile);
        $('#renameButton').attr('data-box', 'renameFile'+dataI);
        $('#deleteButton').attr('data-box', 'deleteFile'+dataI);
        $('#insertButton').attr('data-url', urlFile).attr('data-name', nameFile);
        $('#insertButtonLink').attr('data-url', urlFile).attr('data-name', nameFile);
        setTimeout(function () { $('.fileInfoBox .box-body').css('display', 'block')}, 0);
        $('.box-btn').addClass('widoczny');

    });
    //kopiowanie URL
    $('#returnAjax').on('click', '#fileUrl', function () {
        this.select();
        document.execCommand('copy');
        $('.infoCopyUrl').css('opacity', '1').animate({opacity: '0'}, 3000);
        //$('.infoCopyUrl').animate({opacity: '1'}, 3000);

    });
    $('#returnAjax').on('click', '#deleteButton', function () {
        var id = $(this).attr('data-box');
        $('#'+id).toggle().css('margin-top', '-40%');


    });
    $('#returnAjax').on('click', '#renameButton', function () {
        var id = $(this).attr('data-box');
        $('#'+id).toggle().css('margin-top', '-40%');


    });
    $('#returnAjax').on('click', '#insertButton', function () {
        var foto = $(this).attr('data-url');
        var alt = $(this).attr('data-name');

        if(tinyMCE) {
            var images = '<img src="'+foto+'" alt="'+alt+'">';
            //alert(grid);
            tinyMCE.activeEditor.execCommand('mceInsertContent',false, images);
            $('#mediaModal').foundation('close');
        }
        //$('.infoCopyUrl').animate({opacity: '1'}, 3000);

    });
    $('#returnAjax').on('click', '#insertButtonLink', function () {
        var foto = $(this).attr('data-url');
        var alt = $(this).attr('data-name');

        if(tinyMCE) {
            var images = '<img src="'+foto+'" alt="'+alt+'">';
            //alert(grid);
            tinyMCE.activeEditor.execCommand('mceInsertContent',false, images);
            $('#mediaModal').foundation('close');
        }
        //$('.infoCopyUrl').animate({opacity: '1'}, 3000);

    });

    $('#returnAjax').on('click', '.addFolder', function () {
        $('#addFolder').toggle();
    });
    $('#returnAjax').on('click', '.addFolderClose', function () {
        $('#addFolder').toggle();
    });
    $('#returnAjax').on('click', '.fileInfoBox .box-header .box-title', function () {
        $('.fileInfoBox .box-body').toggle();
    });
    $('#returnAjax').on('click', '.configFileInfo', function () {
        $('.configBoxButtons').toggle();
    });
    $('#returnAjax').on('submit', '#nameNewFolderSend', function (e) {
        e.preventDefault();
        var directory = $(this).attr('data-directory');
        $.ajax({
            type     : "POST",
            url      : Routing.generate('wi_admin_media_tinymce_media_view', { directory: directory }),
            data     : {
                add_folder: 1,
                name: $('#nameNewFolder').val(),
            },
            success: function(ret) {
                $('#returnAjax').html(ret);
                var directory = $('#uploaderFile').attr('data-directory');
                uploadPlikow(directory);
            },
            complete: function() {
            },
            error: function(jqXHR, errorText, errorThrown) {
            }
        });
    });
    $('#returnAjax').on('click', '.opcjeFolderuButton', function () {
        var id = $(this).attr('data-id');
        var vis = $('#'+id).css('visibility');
        if(vis=='visible'){
            $('#'+id).css('visibility', 'hidden');
        } else {
            $('#'+id).css('visibility', 'visible');
        }
    });
    $('#returnAjax').on('click', '.openDeleteFolder', function () {
        var id = $(this).attr('data-id');
        $('#'+id).toggle();
    });
    $('#returnAjax').on('click', '.closeDeleteFolder', function () {
        var id = $(this).attr('data-id');
        $('#'+id).toggle();
    });

    $('#returnAjax').on('submit', '.deleteFolderButton', function (e) {
        e.preventDefault();
        var directory = $(this).attr('data-directory');
        var id = $(this).attr('data-id');
        $.ajax({
            type     : "POST",
            url      : Routing.generate('wi_admin_media_tinymce_media_view', { directory: directory }),
            data     : {
                //delete: 1,
                delete: $('#'+id).val(),
            },
            success: function(ret) {
                $('#returnAjax').html(ret);
                var directory = $('#uploaderFile').attr('data-directory');
                uploadPlikow(directory);

            },
            complete: function() {
            },
            error: function(jqXHR, errorText, errorThrown) {
            }
        });
    });

    $('#returnAjax').on('click', '.changeNameFolder', function () {
        var id = $(this).attr('data-id');
        $('#'+id).toggle();
    });
    $('#returnAjax').on('click', '.closeChangeFolderModal', function () {
        var id = $(this).attr('data-id');
        $('#'+id).toggle();
    });

    $('#returnAjax').on('submit', '.changeFolderForm', function (e) {
        e.preventDefault();
        var id_new = $(this).attr('data-id-new');
        var id_old = $(this).attr('data-id-old');
        var directory = $(this).attr('data-directory');
        $.ajax({
            type     : "POST",
            url      : Routing.generate('wi_admin_media_tinymce_media_view', { directory: directory }),
            data     : {
                rename: 1,
                oldName: $('#'+id_old).val(),
                name: $('#'+id_new).val(),
            },
            success: function(ret) {
                $('#returnAjax').html(ret);
                var directory = $('#uploaderFile').attr('data-directory');
                uploadPlikow(directory);

            },
            complete: function() {
            },
            error: function(jqXHR, errorText, errorThrown) {
            }
        });
    });
    $('#returnAjax').on('click', '.deleteFileButton', function () {
        var id = $(this).attr('data-id');
        $('#'+id).toggle();
    });
    $('#returnAjax').on('click', '.deleteFileModalClose', function () {
        var id = $(this).attr('data-id');
        $('#'+id).toggle();
    });

    $('#returnAjax').on('submit', '.deleteFileForm', function (e) {
        e.preventDefault();
        var id = $(this).attr('data-id');
        var directory = $(this).attr('data-directory');
        $.ajax({
            type     : "POST",
            url      : Routing.generate('wi_admin_media_tinymce_media_view', { directory: directory }),
            data     : {
                //delete: 1,
                delete: $('#'+id).val(),
            },
            success: function(ret) {
                $('#returnAjax').html(ret);
                var directory = $('#uploaderFile').attr('data-directory');
                uploadPlikow(directory);

            },
            complete: function() {
            },
            error: function(jqXHR, errorText, errorThrown) {
            }
        });
    });
    $('#returnAjax').on('click', '.renameFileButton', function () {
        var id = $(this).attr('data-id');
        $('#'+id).toggle();
    });
    $('#returnAjax').on('click', '.renameFileModalClose', function () {
        var id = $(this).attr('data-id');
        $('#'+id).toggle();
    });

    $('#returnAjax').on('submit', '.renameFileModalForm', function (e) {
        e.preventDefault();
        var id_new = $(this).attr('data-id-new');
        var id_old = $(this).attr('data-id-old');
        var directory = $(this).attr('data-directory');
        $.ajax({
            type     : "POST",
            url      : Routing.generate('wi_admin_media_tinymce_media_view', { directory: directory }),
            data     : {
                rename: 1,
                oldName: $('#'+id_old).val(),
                name: $('#'+id_new).val(),
            },
            success: function(ret) {
                $('#returnAjax').html(ret);
                var directory = $('#uploaderFile').attr('data-directory');
                uploadPlikow(directory);

            },
            complete: function() {
            },
            error: function(jqXHR, errorText, errorThrown) {
            }
        });
    });

    $('#returnAjax').on('submit', '#fileAdd', function (e) {
        e.preventDefault();
        var formData = new FormData($('#fileAdd')[0]);
        var directory = $(this).attr('data-directory');
        $.ajax({
            type     : "POST",
            url      : Routing.generate('wi_admin_media_upload', { d: directory }),
            cache: false,
            contentType: false,
            processData: false,
            data     : formData,
            success: function(ret) {
                $.ajax({
                type     : "GET",
                url      : Routing.generate('wi_admin_media_tinymce_media_view'),
                data     : {
                    directory: directory,
                },
                success: function(ret) {
                    $('#returnAjax').html(ret);
                    var directory = $('#uploaderFile').attr('data-directory');
                    uploadPlikow(directory);
                }
            });
            },
            complete: function() {
            },
            error: function(jqXHR, errorText, errorThrown) {
            }
        });
    });

});

function uploadPlikow(directory) {
    "use strict";
    // Przesyłanie plików.
    var uploader = new plupload.Uploader({
        browse_button: 'drop-area',
        url: Routing.generate('wi_admin_media_upload', { d: directory }),
        chunk_size: '200kb',
        max_retries: 3,
        drop_element: 'uploaderFile',
        unique_names: false,
        multi_selection: false,
        filters: {
            mime_types : [
                { title : "Image files", extensions : "avi,jpeg,jpg,mp3,mp4,pdf,png,rar,zip" }
            ]
        },
        init: {
            PostInit: function() {
            },
            FilesAdded: function (up, files) {
                plupload.each(files, function (file) {
                    $('#choosen-file').html(file.name);
                });

                uploader.start();
            },
            FileUploaded: function(up, file, info) {
                var response = JSON.parse(info.response);

                if (response.OK == 0) {
                    alert(response.info);
                    file.status = plupload.FAILED;
                    up.trigger('UploadProgress', file);
                }
            },
            ChunkUploaded: function(up, file, info) {
                var response = JSON.parse(info.response);

                if (response.OK == 0) {
                    alert(response.info);
                    file.status = plupload.FAILED;
                    up.trigger('UploadProgress', file);
                }
            },
            UploadProgress: function(up, file) {
                $('#percent').html(file.percent + '%');
            },
            UploadComplete: function (up, files) {
                $.ajax({
                    type     : "GET",
                    url      : Routing.generate('wi_admin_media_tinymce_media_view'),
                    data     : {
                        directory: directory,
                    },
                    success: function(ret) {
                        $('#returnAjax').html(ret);
                        var directory = $('#uploaderFile').attr('data-directory');
                        uploadPlikow(directory);
                    },
                    complete: function() {
                    },
                    error: function(jqXHR, errorText, errorThrown) {
                    }
                });

            }
        }
    });

    // Inicjalizacja mechanizmu do przesyłania plików.
    uploader.init();

    //style dla pola drag & drop
    $('#uploaderFile').bind('dragenter', function() {
        $(this).css("border", "5px dashed #000000");
    });

    $('#uploaderFile').bind('dragleave', function() {
        $(this).css("border", "none");
    });
};

