$(function () {
    var $editorHtml = $('.editor-html');

    if ($editorHtml.length) {
        var mixedMode = {
            name: "htmlmixed",
            scriptTypes: [
                {
                    matches: /\/x-handlebars-template|\/x-mustache/i,
                    mode: null
                },
                {
                    matches: /(text|application)\/(x-)?vb(a|script)/i,
                    mode: "vbscript"
                }
            ]
          };

        var myCodeMirror = CodeMirror.fromTextArea($editorHtml[0], {
            mode: mixedMode,
            lineNumbers: true,
            readOnly: true
        });
    }
    loadXml(sitemap_link);

    $('#load').click(function (e) {
        e.preventDefault();
        var link = $('#sitemap_link').val().length ? $('#sitemap_link').val() : sitemap_link;
        loadXml(link);
    });
    $('#load-reset').click(function (e) {
        e.preventDefault();
        $('#sitemap_link').val('');
        loadXml(sitemap_link);
    });

    function loadXml(url) {
        $.ajax({
            type: 'GET',
            url: url,
            dataType: 'html',
            cache: false,
            success: function (xml) {
                $('#root_most_ajax_element').val(xml);

                if ($editorHtml.length) {
                    myCodeMirror.getDoc().setValue($('#root_most_ajax_element').val());
                }
            }
        });
    }
});
