<?php

namespace WhiteOctober\BreadcrumbsBundle\DependencyInjection;

use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader\XmlFileLoader;
use Symfony\Component\Config\FileLocator;

class WhiteOctoberBreadcrumbsExtension extends Extension
{
    /**
     * Loads our service, accessible as "white_october_breadcrumbs"
     *
     * @param  array            $configs
     * @param  ContainerBuilder $container
     * @return void
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $this->loadConfiguration($configs, $container);

        $loader = new XmlFileLoader($container, new FileLocator(__DIR__.'/../Resources/config'));
        $loader->load('breadcrumbs.xml');
    }

    /**
     * Loads the configuration in, with any defaults
     *
     * @param array $configs
     * @param \Symfony\Component\DependencyInjection\ContainerBuilder $container
     */
    protected function loadConfiguration(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        if($config['viewTemplate'] === 'WhiteOctoberBreadcrumbsBundle::breadcrumbs.html.twig') {
            trigger_error(
                'Using viewTemplate "'.$config['viewTemplate'].'"" is deprecated and should be replaced by ' .
                '"WhiteOctoberBreadcrumbsBundle::microdata.html.twig"',
                E_USER_DEPRECATED
            );
        }

        $container->setParameter("white_october_breadcrumbs.options", $config);
    }
}
