<?php

namespace Wi\Front\UserBundle\Utils;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Security\Http\HttpUtils;
use Symfony\Component\Security\Http\Logout\DefaultLogoutSuccessHandler;
use Wi\Front\UserBundle\Utils\Logger;
use Wi\Admin\UserBundle\Entity\User;

/**
 * Logout Success Handler
 *
 * Default logout success handler will redirect users to a configured path.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class LogoutSuccessHandler extends DefaultLogoutSuccessHandler
{
    /**
     * @var Logger
     */
    private $logger;

    /**
     * @param HttpUtils $httpUtils
     * @param string    $targetUrl
     */
    public function __construct(HttpUtils $httpUtils, Logger $logger, $targetUrl = '/')
    {
        $this->logger = $logger;

        parent::__construct($httpUtils, $targetUrl);
    }

    /**
     * {@inheritdoc}
     */
    public function onLogoutSuccess(Request $request)
    {
        $user = unserialize($request->getSession()->get('_security_user'));
        $admin = unserialize($request->getSession()->get('_security_admin'));

        if (! $user && $admin) {
            if ($admin->getUser() instanceof User) {
                $user = $admin;
            }
        }

        if ($user) {
            $this->logger->create(5, [
                'user_id' => $user->getUser()->getId(),
                'ip' => $request->server->get('REMOTE_ADDR'),
                'host' => $request->server->get('REMOTE_HOST') ?: gethostbyaddr($request->server->get('REMOTE_ADDR')),
                'descriptions' => 'The logged out successfully.',
            ]);
        }


        return parent::onLogoutSuccess($request);
    }
}
