<?php

namespace Wi\Front\UserBundle\Utils;

use Symfony\Component\DependencyInjection\ContainerInterface;
use Wi\Admin\CoreBundle\Utils\Email as BaseEmail;
use Wi\Admin\UserBundle\Entity\User;

/**
 * Email
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class Email extends BaseEmail
{
    /**
     * Construct.
     *
     * @param ContainerInterface $container
     */
    public function __construct(ContainerInterface $container)
    {
        parent::__construct($container);
    }

    /**
     * Send activation email to user.
     *
     * @param   User $user
     * @return  bool
     */
    public function sendActivationEmail(User $user)
    {
        $res = $this
            ->setTo($user->getEmail())
            ->setSubject('Aktywacja konta')
            ->setView('WiFrontUserBundle:templates:emails/activation.html.php', [
                'user' => $user,
            ])
            ->setMessage()
            ->send()
        ;

        return $res;
    }
}
