<?php

namespace Wi\Front\UserBundle\Utils;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Security\Core\Authentication\Token\TokenInterface;
use Symfony\Component\Security\Http\Authentication\DefaultAuthenticationSuccessHandler;
use Symfony\Component\Security\Http\HttpUtils;
use Wi\Front\UserBundle\Utils\Logger;

/**
 * Authentication Success Handler.
 *
 * Class with the default authentication success handling logic.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class AuthenticationSuccessHandler extends DefaultAuthenticationSuccessHandler
{
    /**
     * @var Logger
     */
    private $logger;

    /**
     * Constructor.
     *
     * @param HttpUtils $httpUtils
     * @param Logger    $logger
     */
    public function __construct(HttpUtils $httpUtils, Logger $logger)
    {
        $this->logger = $logger;

        parent::__construct($httpUtils);
    }

    /**
     * {@inheritdoc}
     */
    public function onAuthenticationSuccess(Request $request, TokenInterface $token)
    {
        // Save user log.
        $this->logger->create(3, [
            'user_id' => $token->getUser()->getId(),
            'ip' => $request->server->get('REMOTE_ADDR'),
            'host' => $request->server->get('REMOTE_HOST') ?: gethostbyaddr($request->server->get('REMOTE_ADDR')),
            'descriptions' => 'The logged in successfully.',
        ]);

        return parent::onAuthenticationSuccess($request, $token);
    }
}
