<?php

namespace Wi\Front\UserBundle\Utils;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\HttpKernelInterface;
use Symfony\Component\Security\Core\Exception\AuthenticationException;
use Symfony\Component\Security\Http\Authentication\DefaultAuthenticationFailureHandler;
use Symfony\Component\Security\Http\HttpUtils;
use Wi\Front\UserBundle\Utils\Logger;

/**
 * Authentication Failure Handler
 *
 * Class with the default authentication failure handling logic.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class AuthenticationFailureHandler extends DefaultAuthenticationFailureHandler
{
    /**
     * @var Logger
     */
    private $loggerUser;

    /**
     * Constructor.
     *
     * @param HttpKernelInterface $httpKernel
     * @param HttpUtils           $httpUtils
     * @param Logger              $loggerUser
     */
    public function __construct(HttpKernelInterface $httpKernel, HttpUtils $httpUtils, Logger $loggerUser)
    {
        $this->loggerUser = $loggerUser;

        parent::__construct($httpKernel, $httpUtils);
    }

    /**
     * {@inheritdoc}
     */
    public function onAuthenticationFailure(Request $request, AuthenticationException $exception)
    {
        $this->loggerUser->create(4, [
            'username' => $request->request->get('_user_username'),
            'ip' => $request->server->get('REMOTE_ADDR'),
            'host' => $request->server->get('REMOTE_HOST') ?: gethostbyaddr($request->server->get('REMOTE_ADDR')),
            'descriptions' => 'The logged in has failed on account ' . $request->request->get('_user_username') . '.',
        ]);

        return parent::onAuthenticationFailure($request, $exception);
    }
}
