<?php

namespace Wi\Front\UserBundle\Service;

use Wi\Admin\CoreBundle\Service\Mailer as BaseMailer;
use Wi\Admin\UserBundle\Entity\User;

/**
 * Mailer.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2018 WEBimpuls Sp. z o.o.
 */
class Mailer extends BaseMailer
{
    /**
     * Wysyła wiadomość e-mail do użytkownika z linkiem aktywacyjnym.
     *
     * @param User $user
     * @return int
     */
    public function sendActivationEmail(User $user) : int
    {
        $this->message
            ->setTo($user->getEmail())
            ->setSubject('Potwierdź adres e-mail')
            ->setBody(
                $this->render('@templates/default/view/Users/templates/emails/activation.html.twig', [
                    'user' => $user,
                ]),
                'text/html'
            )
        ;

        return $this->send();
    }

    /**
     * Wysyła wiadomośc e-mail do administratorów z powiadomieniem o nowym użytkowniku.
     *
     * @param User $user
     * @param array $to
     * @return int
     */
    public function sendNotifyActivationToAdmin(User $user, array $to) : int
    {
        $this->message
            ->setTo($to)
            ->setSubject('Nowy użytkownik')
            ->setBody(
                $this->render('WiFrontUserBundle:templates:emails/notify_admin.html.php', [
                    'user' => $user,
                ]),
                'text/html'
            )
        ;

        return $this->send();

    }

    /**
     * Wysłanie maila z linkiem do zresetowania hasła.
     *
     * @param User $user
     * @return int
     */
    public function sendForgotPasswordEmail(User $user)
    {
        $this->message
            ->setTo($user->getEmail())
            ->setSubject('Zresetuj hasło')
            ->setBody(
                $this->render('@templates/default/view/Users/templates/emails/forgot_password.html.twig', [
                    'user' => $user,
                ]),
                'text/html'
            )
        ;

        return $this->send();
    }
}
