<?php

namespace Wi\Front\UserBundle\Form;

use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints as Assert;
use Wi\Admin\UserBundle\Entity\User;

/**
 * User Interest Type.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class UserAvatarType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('avatar', EntityType::class, [
                'class' => 'WiAdminUserBundle:Avatar',
                'choice_attr' => function ($val, $key, $index) use ($options) {
                    $attr = [];

                    if (! empty($options['data']->getUserAvatars())) {
                        foreach ($options['data']->getUserAvatars() as $userAvatar) {
                            if ($userAvatar->getAvatar()->getId() == $val->getId()) {
                                $attr['checked'] = true;
                            }
                        }
                    }

                    return $attr;
                },
                'choice_label' => 'image',
                'expanded' => true,
                'label' => false,
                'mapped' => false,
                'multiple' => false,
            ])
            ->add('image', FileType::class, [
                'attr' => [
                    'accept' => 'image/jpeg,image/png',
                ],
                'constraints' => [
                    new Assert\File([
                        'maxSize' => "1M",
                        'mimeTypes' => ['image/jpeg', 'image/png'],
                    ]),
                ],
                'mapped' => false,
                'required' => false,
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => User::class,
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'wi_front_userbundle_useravatar';
    }
}
