<?php

namespace Wi\Front\UserBundle\Controller;

use Wi\Front\CoreBundle\Core\Controller\FrontController;

/**
 * Dashboard controller.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class DashboardController extends FrontController
{
    /**
     * Dashboard.
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function indexAction()
    {
        $user = $this->getUser();
        $favoriteNews = $this->getNewsRepo()->findFavoriteNewsByUser($user);
        $favoritePosts = $this->getNewsRepo()->findFavoritePostsByUser($user);

        return $this->render($this->getTemplate('Users/Dashboard/index'), [
            'favoriteNews' => $favoriteNews,
            'favoritePosts' => $favoritePosts,
        ]);
    }

    // -------------------------------------------------------------------------

    /**
     * Pobiera repozytorium dla aktualności/wpisów.
     *
     * @return NewsRepository
     */
    private function getNewsRepo()
    {
        return $this->getDoctrine()->getManager()
            ->getRepository('WiAdminNewsBundle:News')
        ;
    }
}
