<?php

namespace Wi\Front\PageBundle\Controller;

use Wi\Admin\PageBundle\Entity\Page;
use Wi\Front\CoreBundle\Core\Controller\FrontController;

/**
 * Page controller.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class PageController extends FrontController
{
    /**
     * Display page.
     *
     * @param   Page $page
     * @return  \Symfony\Component\HttpFoundation\Response
     */
    public function indexAction(Page $page)
    {
        if ($page->getStatus() != 'A') {
            throw $this->createNotFoundException('Podana strona nie została odnaleziona.');
        }
        // Breadcrumbs.
        $this->breadcrumbs->addItem($page->getTitle(), $this->generateUrl("wi_front_page_index", ['id'=>$page->getId(), 'slug'=>$this->slugify($page->getTitle())]));

        // Increment visit counter, when user is not admin.
        if (! $this->isGranted('ROLE_ADMIN')) {
            $page->setVisitCounter($page->getVisitCounter() + 1);
            $this->getDoctrine()->getManager()->flush();
        }

        return $this->responseCache(
            $this->render($this->getTemplate('Page/index'), [
                'page' => $page,
            ]),
            'page' // type of object
        );
    }
}
