<?php

namespace Wi\Front\DownloadBundle\Controller;

use Knp\Component\Pager\Paginator;
use Symfony\Component\HttpFoundation\Request;
use Wi\Admin\DownloadBundle\Entity\Category;
use Wi\Admin\DownloadBundle\Entity\File;
use Wi\Front\CoreBundle\Core\Controller\FrontController;
use Symfony\Component\HttpFoundation\ResponseHeaderBag;
/**
 * File controller.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2018 WEBimpuls Sp. z o.o.
 */
class FileController extends FrontController
{
    /**
     * Lista plików do pobrania.
     *
     * @param Paginator $paginator
     * @param Request $request
     * @param Category $category
     * @param int $page
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function indexAction(Paginator $paginator, Request $request, Category $category = null, int $page = 1)
    {
        $em = $this->getDoctrine()->getManager();
        $files = $paginator->paginate(
            $em->getRepository('WiAdminDownloadBundle:File')
                ->getFindAllActiveQuery(
                    ($category ? $category->getId() : null)
                ),
            $request->query->getInt('page', $page),
            10
        );

        return $this->render($this->getTemplate('Download/index'), [
            'files' => $files,
        ]);
    }

    /**
     * Pobieranie plików.
     *
     * @param File $file
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function downloadAction(File $file)
    {
        // Increment download counter, when user is not admin.
        if (! $this->isGranted('ROLE_ADMIN')) {
            $file->setDownloadCount($file->getDownloadCount() + 1);
            $this->getDoctrine()->getManager()->flush($file);
        }

        return $this->file(
            $this->getParameter('upload_dirs.files') . $file->getSystemName(),
            $file->getTitle() . '.' . $file->getExt()
        );
    }
}
