<?php

namespace Wi\Admin\UserBundle\Utils;

use Symfony\Component\DependencyInjection\ContainerInterface;
use Wi\Admin\CoreBundle\Utils\Upload;

/**
 * Upload avatar for User.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class UploadUserAvatar extends Upload
{
    /**
     * Constructor.
     *
     * @param ContainerInterface $container
     */
    public function __construct(ContainerInterface $container)
    {
        // Called to parent construct.
        parent::__construct($container);

        // Get config.
        $config = $container->get('config');

        // Set user image config.
        $this->config = [
            '' => [
                'width' => (int) $config->get('user.imageWidth'),
                'height' => (int) $config->get('user.imageHeight'),
            ],
        ];

        // Set a directory.
        $this->dir = $this->container->getParameter('assets_dirs.user');
    }
}
