<?php

namespace Wi\Admin\UserBundle\User;

use Doctrine\ORM\EntityManagerInterface;

/**
 * Menedżer ulubionych.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2018 WEBimpuls Sp. z o.o.
 */
class FavoriteManager
{
    /**
     * @var EntityManagerInterface
     */
    private $em;

    /**
     * Constructor.
     *
     * @param EntityManagerInterface $em
     */
    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }

    /**
     * Dodanie do ulubionych.
     *
     * @param int $type
     * @param int $user_id
     * @param int $object_id
     * @return bool
     */
    public function add(int $type, int $user_id, int $object_id) : bool
    {
        switch ($type) {
            case 1: // Aktualności/wpisy.
                return $this->addNews($user_id, $object_id);
        }

        return false;
    }

    /**
     * Usunięcie z ulubionych.
     *
     * @param int $type
     * @param int $user_id
     * @param int $object_id
     * @return bool
     */
    public function remove(int $type, int $user_id, int $object_id) : bool
    {
        switch ($type) {
            case 1: // Aktualności/wpisy.
                return $this->removeNews($user_id, $object_id);
        }

        return false;
    }

    // -------------------------------------------------------------------------

    /**
     * Dodanie aktualności/wpisu do ulubionych.
     *
     * @param int $user_id
     * @param int $id
     * @return bool
     */
    private function addNews(int $user_id, int $id) : bool
    {
        $news = $this->em->getRepository('WiAdminNewsBundle:News')->find($id);
        $user = $this->getUser($user_id);

        if (! $news || ! $user) {
            return false;
        }

        if ($user->getFavoriteNews()->contains($news)) {
            return false;
        }

        $user->addFavoriteNews($news);
        $this->em->persist($user);
        $this->em->flush($user);

        return true;
    }

    /**
     * Usunięcie aktualności/wpisu z ulubionych.
     *
     * @param int $user_id
     * @param int $id
     * @return bool
     */
    private function removeNews(int $user_id, int $id) : bool
    {
        $news = $this->em->getRepository('WiAdminNewsBundle:News')->find($id);
        $user = $this->getUser($user_id);

        if (! $news || ! $user) {
            return false;
        }

        if ($user->getFavoriteNews()->contains($news)) {
            $user->removeFavoriteNews($news);
            $this->em->persist($user);
            $this->em->flush($user);

            return true;
        }

        return false;
    }

    /**
     * Pobranie użytkownika.
     *
     * @param int $id
     * @return User|null
     */
    private function getUser(int $id)
    {
        return $this->em->getRepository('WiAdminUserBundle:User')->find($id);
    }
}
