<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_users_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.users.List')) ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css') ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css') ?>"  rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/users.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"/>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.administration'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_users_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.users.List'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <i class="icon-users"></i><?php echo $view['translator']->trans('users.listTitle'); ?> - <?php echo $view['translator']->trans('usersList.subTitle'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('usersList.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span class="box-btn" data-toggle="configCategory-dropdown">
                    <i class="icon-cog-5"></i>
                </span>
                <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configCategory-dropdown" data-dropdown data-close-on-click="true">
                    <ul class="no-bullet">
                        <li>
                            <a class="" href="<?php echo $view['router']->path('wi_admin_users_avatars_index'); ?>" title="<?php echo $view['translator']->trans('usersList.buttons.avatar'); ?>">
                                <span>
                                    <i class="icon-user-circle"></i>
                                    <?php echo $view['translator']->trans('usersList.buttons.avatar'); ?>
                                </span>
                            </a>
                        </li>
                        <li>
                            <a class="" href="<?php echo $view['router']->path('wi_admin_users_interests_index'); ?>" title="<?php echo $view['translator']->trans('usersList.buttons.interest'); ?>">
                                <span>
                                    <i class="icon-bicycle"></i>
                                    <?php echo $view['translator']->trans('usersList.buttons.interest'); ?>
                                </span>
                            </a>
                        </li>
                        <li>
                            <a class="" href="<?php echo $view['router']->path('wi_admin_users_log_types_index'); ?>" title="<?php echo $view['translator']->trans('usersList.buttons.logsType'); ?>">
                                <span>
                                    <i class="icon-th-list"></i>
                                    <?php echo $view['translator']->trans('usersList.buttons.logsType'); ?>
                                </span>
                            </a>
                        </li>
                        <li class="odciecie">
                            <a class="" href="<?php echo $view['router']->path('wi_admin_users_logs_index'); ?>" title="<?php echo $view['translator']->trans('usersList.buttons.logs'); ?>">
                                <span>
                                    <i class="icon-vcard"></i>
                                    <?php echo $view['translator']->trans('usersList.buttons.logs'); ?>
                                </span>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
            <h3 class="box-title"><i class="icon-th-list-outline"></i>
                <span><?php echo $view['translator']->trans('usersList.listSubTitle'); ?></span>
            </h3>
            <?php echo $view->render('KnpPaginatorBundle/Pagination/search.html.php', [
                'knp_pagination' => $users,
            ]); ?>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="columns tableResp">
                    <table id="usersList">
                        <thead>
                        <tr>
                            <th><?php echo $view['knp_pagination']->sortable($users, $view['translator']->trans('usersList.table.id'), 'u.id'); ?></th>
                            <th><?php echo $view['translator']->trans('usersList.table.avatar'); ?></th>
                            <th><?php echo $view['knp_pagination']->sortable($users, $view['translator']->trans('usersList.table.email'), 'u.email'); ?></th>
                            <th><?php echo $view['knp_pagination']->sortable($users, $view['translator']->trans('usersList.table.FirstName'), 'up.firstName'); ?></th>
                            <th><?php echo $view['knp_pagination']->sortable($users, $view['translator']->trans('usersList.table.LastName'), 'up.lastName'); ?></th>
                            <th><?php echo $view['knp_pagination']->sortable($users, $view['translator']->trans('usersList.table.Sex'), 'up.sex'); ?></th>
                            <th><?php echo $view['knp_pagination']->sortable($users, $view['translator']->trans('usersList.table.DateOfBirth'), 'up.dateOfBirth'); ?></th>
                            <th><?php echo $view['translator']->trans('usersList.table.Status'); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($users as $user): ?>
                            <?php
                            $userAvatar = ($user->getUserAvatars()->count() > 0) ? $user->getUserAvatars()->first() : null;
                            $profile = ($user->getProfile()->count() > 0) ? $user->getProfile()->first() : null;
                            ?>
                            <tr>
                                <td><?php echo $user->getId(); ?></td>
                                <td class="listaAvatar">
                                    <?php if (! is_null($userAvatar)): ?>
                                        <a href="<?php echo $view['router']->path('wi_admin_users_show', ['id' => $user->getId(),]); ?>">
                                            <img class="thumbnail" src="<?php echo $view['assets']->getUrl('media/avatars/'.$userAvatar->getAvatar()->getImage()); ?>" alt="<?php echo $user->getEmail(); ?>">
                                        </a>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="<?php echo $view['router']->path('wi_admin_users_show', ['id' => $user->getId(),]); ?>" title="">
                                        <b>
                                            <?php echo $user->getEmail(); ?>
                                        </b>
                                    </a>
                                    <div class="buttonItemsBox">
                                        <div class="buttonsItems">
                                            <a href="<?php echo $view['router']->path('wi_admin_users_show', ['id' => $user->getId()]); ?>" class=""><i class="icon-eye-1"></i><?php echo $view['translator']->trans('Table.showButton'); ?></a> /
                                            <?php if ($view['security']->isGranted('ROLE_USERS_EDIT')): ?>
                                                <a href="<?php echo $view['router']->path('wi_admin_users_edit', ['id' => $user->getId()]); ?>" class=""><i class="icon-edit-1"></i><?php echo $view['translator']->trans('Table.editButton'); ?></a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <?php if (! is_null($profile)): ?>
                                        <?php echo $profile->getFirstName(); ?>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if (! is_null($profile)): ?>
                                        <?php echo $profile->getLastName(); ?>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if (! is_null($profile)): ?>
                                        <?php echo $profile->getSex(); ?>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if (! is_null($profile) && ! is_null($profile->getDateOfBirth())): ?>
                                        <?php echo $profile->getDateOfBirth()->format('d-m-Y'); ?>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($user->getStatus()=='A'): ?>
                                        <?php echo $view['translator']->trans('usersList.status.active'); ?>
                                    <?php elseif ($user->getStatus()=='B'): ?>
                                        <?php echo $view['translator']->trans('usersList.status.blocked'); ?>
                                    <?php else: ?>
                                        <?php echo $view['translator']->trans('usersList.status.notActive'); ?>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="row">
                <div class="medium-6 columns"></div>
                <div class="medium-6 columns paginationBox">
                    <?php echo $view->render('KnpPaginatorBundle/Pagination/per_page.html.php', [
                        'knp_pagination' => $users,
                    ]); ?>
                    <?php echo $view['knp_pagination']->render($users); ?>
                </div>
            </div>
        </div>
    </div>
    <script>
        var language = '<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery/dataTables/i18n/'.$view['request']->getLocale().'.json'); ?>';
    </script>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/jquery.tooltipster.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/users.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
