<?php

namespace Wi\Admin\UserBundle\Repository;

use Doctrine\ORM\EntityRepository;

/**
 * UserRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class UserRepository extends EntityRepository
{
    /**
     * Pobiera zapytanie dla wszystkich użytkowników.
     *
     * @param   string $search Search text.
     * @return  Query
     */
    public function getFindAllQuery($search = '')
    {
        // Utworzenie QueryBuilder'a.
        $qb = $this->createQueryBuilder('u')
            ->leftJoin('u.profile', 'up')
            ->leftJoin('u.billingData', 'ub')
            ->leftJoin('u.userAvatars', 'ua')
        ;

        // Ustawienie parametrów dla zapytania.
        $params = [];

        // Jeśli tekst do wyszukania jest przekazany to szukaj.
        if ($search) {
            $params['search'] = '%' . $search . '%';
            $qb->andWhere($qb->expr()->orX(
                $qb->expr()->like('u.email', ':search'),
                $qb->expr()->like('ub.name', ':search'),
                $qb->expr()->like('ub.address', ':search'),
                $qb->expr()->like('ub.zip', ':search'),
                $qb->expr()->like('ub.city', ':search'),
                $qb->expr()->like('ub.country', ':search'),
                $qb->expr()->like('ub.NIP', ':search'),
                $qb->expr()->like('up.firstName', ':search'),
                $qb->expr()->like('up.lastName', ':search'),
                $qb->expr()->like('up.dateOfBirth', ':search')
            ));
        }

        return $qb
            ->setParameters($params)
            ->getQuery()
        ;
    }
}
