<?php

namespace Wi\Admin\UserBundle\Repository;

use Doctrine\ORM\EntityRepository;
use Wi\Admin\UserBundle\Entity\User;

/**
 * LogRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class LogRepository extends EntityRepository
{
    /**
     * Pobiera wszystkie logi użytkowników.
     *
     * @param   string  $search Search text.
     * @return  Query
     */
    public function getLogsQuery($search = '')
    {
        $qb = $this->createQueryBuilder('l')
            ->innerJoin('l.logType', 'lt')
            ->leftJoin('l.user', 'lu')
            ->leftJoin('lu.profile', 'lup')
        ;

        // Ustawienie parametrów dla zapytania.
        $params = [];

        // Jeśli tekst do wyszukania jest przekazany to szukaj.
        if ($search) {
            $params['search'] = '%' . $search . '%';
            $qb->andWhere($qb->expr()->orX(
                $qb->expr()->like('lt.name', ':search'),
                $qb->expr()->like('lu.email', ':search'),
                $qb->expr()->like('lup.firstName', ':search'),
                $qb->expr()->like('lup.lastName', ':search'),
                $qb->expr()->like('l.descriptions', ':search'),
                $qb->expr()->like('l.host', ':search'),
                $qb->expr()->like('l.ip', ':search'),
                $qb->expr()->like('l.datetime', ':search')
            ));
        }

        return $qb
            ->setParameters($params)
            ->getQuery()
        ;
    }

    /**
     * Pobiera wszystkie logi użytkownika.
     *
     * @param   User    $user   Użytkownik.
     * @param   string  $search Search text.
     * @return  Query
     */
    public function getLogsByUserQuery(User $user, $search = '')
    {
        $qb = $this->createQueryBuilder('l')
            ->innerJoin('l.logType', 'lt')
            ->where('l.user = :user')
        ;

        // Ustawienie parametrów dla zapytania.
        $params = [
            'user' => $user,
        ];

        // Jeśli tekst do wyszukania jest przekazany to szukaj.
        if ($search) {
            $params['search'] = '%' . $search . '%';
            $qb->andWhere($qb->expr()->orX(
                $qb->expr()->like('lt.name', ':search'),
                $qb->expr()->like('l.descriptions', ':search'),
                $qb->expr()->like('l.host', ':search'),
                $qb->expr()->like('l.ip', ':search'),
                $qb->expr()->like('l.datetime', ':search')
            ));
        }

        return $qb
            ->setParameters($params)
            ->getQuery()
        ;
    }
}
