<?php

namespace Wi\Admin\UserBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Wi\Admin\UserBundle\Entity\User;

/**
 * User Type.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class UserType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('password', RepeatedType::class, [
                'type' => PasswordType::class,
                'invalid_message' => 'Repeated password not matched.',
                'invalid_message_parameters' => array('class' => 'alert callout small'),
                'first_options' => [
                    'attr' => ['placeholder' => 'usersEdit.form.password'],
                    'label' => 'usersEdit.form.password',
                ],
                'second_options' => [
                    'attr' => ['placeholder' => 'usersEdit.form.repeadPassword'],
                    'label' => 'usersEdit.form.repeadPassword',
                ],
                'required' => true,
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => User::class,
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'wi_admin_userbundle_user';
    }


}
