<?php

namespace Wi\Admin\UserBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Wi\Admin\UserBundle\Entity\Profile;

/**
 * Profile Type.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class ProfileType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('firstName', TextType::class, [
                'attr' => [
                    'maxlength' => 64,
                    'placeholder' => 'usersEdit.form.firstName'
                ],
                'required' => false,
                'label' => 'usersEdit.form.firstName',
            ])
            ->add('lastName', TextType::class, [
                'attr' => [
                    'maxlength' => 64,
                    'placeholder' => 'usersEdit.form.lastName'
                ],
                'required' => false,
                'label' => 'usersEdit.form.lastName',
            ])
            ->add('sex', ChoiceType::class, [
                'choices' => [
                    'Male' => 'M',
                    'Female' => 'F',
                ],
                'attr' => [
                    'class' => 'chosenSelect',
                ],
                'placeholder' => 'usersEdit.form.sex',
                'required' => false,
                'label' => 'usersEdit.form.sexLabel',
            ])
            ->add('dateOfBirth', DateType::class, [
                'attr' => [
                    'class' => 'datePicker',
                    'placeholder' => 'usersEdit.form.dateOfBirthPlace'
                ],
                'format' => 'dd-MM-yyyy',
                'html5' => false,
                'required' => false,
                'widget' => 'single_text',
                'label' => 'usersEdit.form.dateOfBirth',
            ])
            ->add('description', TextareaType::class, [
                'attr' => [
                    'maxlength' => 65535,
                    'rows' => 10,
                    'placeholder' => 'usersEdit.form.description'
                ],
                'required' => false,
                'label' => 'usersEdit.form.description',
            ])
            ->add('pesel', TextType::class, [
                'attr' => [
                    'maxlength' => 16,
                ],
                'required' => false,
                'label' => 'usersEdit.form.pesel',
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => Profile::class,
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'wi_admin_userbundle_profile';
    }


}
