<?php

namespace Wi\Admin\UserBundle\EventListener\Entity;

use Doctrine\ORM\Event\LifecycleEventArgs;
use Symfony\Component\HttpFoundation\RequestStack;
use Wi\Admin\NewsLetterBundle\User\RegisterUserManager;
use Wi\Admin\UserBundle\Entity\User;

/**
 * Class UserListener
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2018 WEBimpuls Sp. z o.o.
 */
class UserListener
{
    /**
     * @var RequestStack
     */
    private $requestStack;

    /**
     * @var RegisterUserManager
     */
    private $registerUserManager;

    // -------------------------------------------------------------------------

    /**
     * Construct.
     *
     * @param RequestStack $requestStack
     * @param RegisterUserManager $registerUserManager
     */
    public function __construct(RequestStack $requestStack, RegisterUserManager $registerUserManager)
    {
        $this->requestStack = $requestStack;
        $this->registerUserManager = $registerUserManager;
    }

    // -------------------------------------------------------------------------
    // Lifecycle callbacks.
    // -------------------------------------------------------------------------

    /**
     * Funkcja wykonuje się po wstawieniu nowego rekordu do bazy.
     *
     * @param User $user
     * @param LifecycleEventArgs $args
     */
    public function postPersist(User $user, LifecycleEventArgs $args)
    {
        $this->registerUserManager->changeSubscribe($user);
    }

    /**
     * Funkcja wykonuje się po aktualizacji rekordu do bazy.
     *
     * @param User $user
     * @param LifecycleEventArgs $args
     */
    public function postUpdate(User $user, LifecycleEventArgs $args)
    {
        $this->registerUserManager->changeSubscribe($user);
    }
}
