<?php

namespace Wi\Admin\UserBundle\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Wi\Admin\UserBundle\Entity\UserAvatar;

/**
 * Avatar
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 *
 * @ORM\Table(name="user_avatars")
 * @ORM\Entity(repositoryClass="Wi\Admin\UserBundle\Repository\AvatarRepository")
 */
class Avatar
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=64)
     */
    private $name;

    /**
     * @var string
     *
     * @ORM\Column(name="image", type="string", length=256)
     */
    private $image;

    /**
     * @var string
     *
     * @ORM\Column(name="status", type="string", length=1, options={"default": "A", "fixed" = true})
     */
    private $status;

    /**
     * @var ArrayCollection
     *
     * @ORM\OneToMany(targetEntity="Wi\Admin\UserBundle\Entity\UserAvatar", mappedBy="avatar")
     */
    private $userAvatars;


    // ------------------------------------------------------------
    // Getters and setters methods.
    // ------------------------------------------------------------

    /**
     * Set id
     *
     * @param int $id
     * @return Avatar
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return Avatar
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set image
     *
     * @param string $image
     * @return Avatar
     */
    public function setImage($image)
    {
        $this->image = $image;

        return $this;
    }

    /**
     * Get image
     *
     * @return string
     */
    public function getImage()
    {
        return $this->image;
    }

    /**
     * Set status
     *
     * @param string $status
     * @return Avatar
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get status
     *
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Add userAvatar
     *
     * @param UserAvatar $userAvatar
     * @return Avatar
     */
    public function addUserAvatar(UserAvatar $userAvatar)
    {
        $this->userAvatars[] = $userAvatar;

        return $this;
    }

    /**
     * Remove userAvatar
     *
     * @param UserAvatar $userAvatar
     */
    public function removeUserAvatar(UserAvatar $userAvatar)
    {
        $this->userAvatars->removeElement($userAvatar);
    }

    /**
     * Get userAvatars
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getUserAvatars()
    {
        return $this->userAvatars;
    }

    // ------------------------------------------------------------
    // Methods.
    // ------------------------------------------------------------

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->userAvatars = new ArrayCollection();
    }

    /**
     * Zwraca link do avataru.
     *
     * @return string
     */
    public function getImageLink() : string
    {
        return 'media/avatars/' . $this->image;
    }
}
