<?php

namespace Wi\Admin\UserBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Wi\Admin\UserBundle\Entity\LogType;

/**
 * Załadowanie typów logów użytkownika.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class LoadUserLogsTypeData extends AbstractFixture implements OrderedFixtureInterface
{
    /**
     * {@inheritdoc}
     */
    public function load(ObjectManager $manager)
    {
        foreach ($this->getData() as $data) {
            $logType = $this->getLogType($data);

            // Przygotowanie do zapisu.
            $manager->persist($logType);

            // Wymuszenie podania ID.
            $metadata = $manager->getClassMetaData(get_class($logType));
            $metadata->setIdGeneratorType(\Doctrine\ORM\Mapping\ClassMetadata::GENERATOR_TYPE_NONE);
        }

        // Zapis.
        $manager->flush();
    }

    /**
     * {@inheritdoc}
     */
    public function getOrder()
    {
        return 21;
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Tablica danych.
     *
     * @return mixed[]
     */
    private function getData()
    {
        return [
            [
                'id' => 1,
                'name' => 'Registration',
                'type' => 'I',
            ],
            [
                'id' => 2,
                'name' => 'Account activation',
                'type' => 'I',
            ],
            [
                'id' => 3,
                'name' => 'Logged in',
                'type' => 'I',
            ],
            [
                'id' => 4,
                'name' => 'Incorrect login',
                'type' => 'W',
            ],
            [
                'id' => 5,
                'name' => 'Logged out',
                'type' => 'I',
            ],
            [
                'id' => 6,
                'name' => 'Password change',
                'type' => 'I',
            ],
            [
                'id' => 7,
                'name' => 'Password change error',
                'type' => 'W',
            ],
            [
                'id' => 8,
                'name' => 'Billing data change',
                'type' => 'I',
            ],
            [
                'id' => 9,
                'name' => 'Billing data change error',
                'type' => 'W',
            ],
            [
                'id' => 10,
                'name' => 'Profile data change',
                'type' => 'I',
            ],
            [
                'id' => 11,
                'name' => 'Profile data change error',
                'type' => 'W',
            ],
        ];
    }

    /**
     * Tworzy nowy obiekt na podstawie przekazanej tablicy danych.
     *
     * @param array $data
     * @return \Wi\Admin\UserBundle\Entity\LogType
     */
    private function getLogType(array $data)
    {
        return (new LogType())
            ->setId($data['id'])
            ->setName($data['name'])
            ->setType($data['type'])
        ;
    }
}
