<?php

namespace Wi\Admin\UserBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Wi\Admin\UserBundle\Entity\UserInterest;

/**
 * Załadowanie zainteresowań do użytkowników.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class LoadUserInterestData extends AbstractFixture implements OrderedFixtureInterface
{
    /**
     * {@inheritdoc}
     */
    public function load(ObjectManager $manager)
    {
        foreach ($this->getData() as $data) {
            $userInterest = $this->getUserInterest($data);

            // Przygotowanie do zapisu.
            $manager->persist($userInterest);

            // Wymuszenie podania ID.
            $metadata = $manager->getClassMetaData(get_class($userInterest));
            $metadata->setIdGeneratorType(\Doctrine\ORM\Mapping\ClassMetadata::GENERATOR_TYPE_NONE);
        }

        // Zapis.
        $manager->flush();
    }

    /**
     * {@inheritdoc}
     */
    public function getOrder()
    {
        return 28;
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Tablica danych.
     *
     * @return mixed[]
     */
    private function getData()
    {
        return [];
    }

    /**
     * Tworzy nowy obiekt na podstawie przekazanej tablicy danych.
     *
     * @param array $data
     * @return \Wi\Admin\UserBundle\Entity\UserInterest
     */
    private function getUserInterest(array $data)
    {
        return (new UserInterest())
            ->setId($data['id'])
            ->setUser($this->getReference('ub-user-' . $data['user']))
            ->setInterest($this->getReference('ub-interest-' . $data['interest']))
        ;
    }
}
