<?php

namespace Wi\Admin\UserBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Wi\Admin\UserBundle\Entity\User;

/**
 * Załadowanie użytkowników.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class LoadUserData extends AbstractFixture implements OrderedFixtureInterface
{
    /**
     * {@inheritdoc}
     */
    public function load(ObjectManager $manager)
    {
        foreach ($this->getData() as $data) {
            $user = $this->getUser($data);
            $this->addReference('ub-user-'.$data['id'], $user);

            // Przygotowanie do zapisu.
            $manager->persist($user);

            // Wymuszenie podania ID.
            $metadata = $manager->getClassMetaData(get_class($user));
            $metadata->setIdGeneratorType(\Doctrine\ORM\Mapping\ClassMetadata::GENERATOR_TYPE_NONE);
        }

        // Zapis.
        $manager->flush();
    }

    /**
     * {@inheritdoc}
     */
    public function getOrder()
    {
        return 24;
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Tablica danych.
     *
     * @return mixed[]
     */
    private function getData()
    {
        return [];
    }

    /**
     * Tworzy nowy obiekt na podstawie przekazanej tablicy danych.
     *
     * @param array $data
     * @return \Wi\Admin\UserBundle\Entity\User
     */
    private function getUser(array $data)
    {
        return (new User())
            ->setId($data['id'])
            ->setEmail($data['email'])
            ->setPassword($data['password'])
            ->setHashCode($data['hashCode'])
            ->setStatus($data['status'])
        ;
    }
}
