<?php

namespace Wi\Admin\UserBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Wi\Admin\UserBundle\Entity\UserAvatar;

/**
 * Załadowanie avatarów do użytkowników.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class LoadUserAvatarData extends AbstractFixture implements OrderedFixtureInterface
{
    /**
     * {@inheritdoc}
     */
    public function load(ObjectManager $manager)
    {
        foreach ($this->getData() as $data) {
            $userAvatar = $this->getUserAvatar($data);

            // Przygotowanie do zapisu.
            $manager->persist($userAvatar);

            // Wymuszenie podania ID.
            $metadata = $manager->getClassMetaData(get_class($userAvatar));
            $metadata->setIdGeneratorType(\Doctrine\ORM\Mapping\ClassMetadata::GENERATOR_TYPE_NONE);
        }

        // Zapis.
        $manager->flush();
    }

    /**
     * {@inheritdoc}
     */
    public function getOrder()
    {
        return 27;
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Tablica danych.
     *
     * @return mixed[]
     */
    private function getData()
    {
        return [];
    }

    /**
     * Tworzy nowy obiekt na podstawie przekazanej tablicy danych.
     *
     * @param array $data
     * @return \Wi\Admin\UserBundle\Entity\UserAvatar
     */
    private function getUserAvatar(array $data)
    {
        return (new UserAvatar())
            ->setId($data['id'])
            ->setUser($this->getReference('ub-user-' . $data['user']))
            ->setAvatar($this->getReference('ub-avatar-' . $data['avatar']))
        ;
    }
}
