<?php

namespace Wi\Admin\UserBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Wi\Admin\UserBundle\Entity\Avatar;

/**
 * Załadowanie avatarów użytkownika.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class LoadAvatarData extends AbstractFixture implements OrderedFixtureInterface
{
    /**
     * {@inheritdoc}
     */
    public function load(ObjectManager $manager)
    {
        foreach ($this->getData() as $data) {
            $avatar = $this->getAvatar($data);
            $this->addReference('ub-avatar-'.$data['id'], $avatar);

            // Przygotowanie do zapisu.
            $manager->persist($avatar);

            // Wymuszenie podania ID.
            $metadata = $manager->getClassMetaData(get_class($avatar));
            $metadata->setIdGeneratorType(\Doctrine\ORM\Mapping\ClassMetadata::GENERATOR_TYPE_NONE);
        }

        // Zapis.
        $manager->flush();
    }

    /**
     * {@inheritdoc}
     */
    public function getOrder()
    {
        return 22;
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Tablica danych.
     *
     * @return mixed[]
     */
    private function getData()
    {
        return [
            [
                'id' => 1,
                'name' => 'Men-1',
                'image' => 'avatar-men-1.png',
                'status' => 'A',
            ],
            [
                'id' => 2,
                'name' => 'Men-2',
                'image' => 'avatar-men-2.png',
                'status' => 'A',
            ],
            [
                'id' => 3,
                'name' => 'Men-3',
                'image' => 'avatar-men-3.png',
                'status' => 'A',
            ],
            [
                'id' => 4,
                'name' => 'Women-1',
                'image' => 'avatar-women-1.png',
                'status' => 'A',
            ],
            [
                'id' => 5,
                'name' => 'Women-2',
                'image' => 'avatar-women-2.png',
                'status' => 'A',
            ],
            [
                'id' => 6,
                'name' => 'Women-3',
                'image' => 'avatar-women-3.png',
                'status' => 'A',
            ],
        ];
    }

    /**
     * Tworzy nowy obiekt na podstawie przekazanej tablicy danych.
     *
     * @param array $data
     * @return \Wi\Admin\UserBundle\Entity\Avatar
     */
    private function getAvatar(array $data)
    {
        return (new Avatar())
            ->setId($data['id'])
            ->setName($data['name'])
            ->setImage($data['image'])
            ->setStatus($data['status'])
        ;
    }
}
