<?php

namespace Wi\Admin\UserBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;

/**
 * Log Type controller.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class LogTypeController extends Controller
{
    /**
     * List of log types.
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function indexAction()
    {
        // Utworzenie instancji EntityManager-a.
        $em = $this->getDoctrine()->getManager();

        // Pobranie listy wszystkich typów logów.
        $logTypes = $em->getRepository('WiAdminUserBundle:LogType')->findBy(
            [],
            ['name' => 'ASC']
        );

        return $this->render('WiAdminUserBundle:LogType:index.html.php', [
            'logTypes' => $logTypes,
        ]);
    }
}
