<?php

namespace Wi\Admin\UserBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Wi\Admin\CoreBundle\Form\DeleteType;
use Wi\Admin\UserBundle\Entity\Interest;
use Wi\Admin\UserBundle\Form\InterestType;

/**
 * Interest controller.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class InterestController extends Controller
{
    /**
     * List of interests.
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function indexAction()
    {
        // Utworzenie instancji EntityManager-a.
        $em = $this->getDoctrine()->getManager();

        // Pobranie listy wszystkich zainteresowań.
        $interests = $em->getRepository('WiAdminUserBundle:Interest')->findBy(
            [],
            ['name' => 'ASC']
        );

        return $this->render('WiAdminUserBundle:Interest:index.html.php', [
            'interests' => $interests,
        ]);
    }

    /**
     * Dodawania zainteresowania.
     *
     * @param Request $request
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function newAction(Request $request)
    {
        $interest = new Interest();
        $form = $this->createForm(InterestType::class, $interest);
        $form->handleRequest($request);

        // Weryfikacja, czy formularz został przesłany i pomyślnie zwalidowany.
        if ($form->isSubmitted() && $form->isValid()) {
            // Utworzenie instancji EntityManager-a.
            $em = $this->getDoctrine()->getManager();
            $em->persist($interest);
            $em->flush();

            return $this->redirectToRoute('wi_admin_users_interests_index');
        }

        return $this->render('WiAdminUserBundle:Interest:new.html.php', [
            'form' => $form->createView(),
            'interest' => $interest,
        ]);
    }

    /**
     * Edycja zainteresowania.
     *
     * @param Request $request
     * @param Interest $interest
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function editAction(Request $request, Interest $interest)
    {
        $form = $this->createForm(InterestType::class, $interest);
        $form->handleRequest($request);

        // Weryfikacja, czy formularz został przesłany i pomyślnie zwalidowany.
        if ($form->isSubmitted() && $form->isValid()) {
            // Utworzenie instancji EntityManager-a.
            $em = $this->getDoctrine()->getManager();
            $em->persist($interest);
            $em->flush();

            return $this->redirectToRoute('wi_admin_users_interests_index');
        }

        return $this->render('WiAdminUserBundle:Interest:edit.html.php', [
            'form' => $form->createView(),
            'interest' => $interest,
        ]);
    }

    /**
     * Edycja zainteresowania.
     *
     * @param Request $request
     * @param Interest $interest
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function deleteAction(Request $request, Interest $interest)
    {
        $form = $this->createForm(DeleteType::class);
        $form->handleRequest($request);

        // Weryfikacja czy formularz został przesłany i pomyślnie zwalidowany.
        if ($form->isSubmitted() && $form->isValid()) {
            // Utworzenie instancji EntityManager-a.
            $em = $this->getDoctrine()->getManager();

            // Usunięcie.
            $em->remove($interest);
            $em->flush();

            return $this->redirectToRoute('wi_admin_users_interests_index');
        }

        return $this->render('WiAdminUserBundle:Interest:delete.html.php', [
            'form' => $form->createView(),
            'interest' => $interest,
        ]);
    }
}
