<?php

namespace Wi\Admin\UserBundle\Controller\Datatable;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

/**
 * User Controller for Datatable.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class UserController extends Controller
{
    /**
     * Get user transaction list for datatables.
     *
     * @param   Request         $request
     * @return  JsonResponse
     */
    public function transactionAction(Request $request)
    {
        $search = $request->query->get('search');
        $draw = $request->query->getInt('draw');
        $start = $request->query->getInt('start');
        $length = $request->query->getInt('length');
        $columns = $request->query->get('columns');
        $order = $request->query->get('order');

        // Utworzenie instancji EntityManager-a.
        $em = $this->getDoctrine()->getManager();

        // Pobranie użytkownika.
        $user = $em->getRepository('WiAdminUserBundle:User')
            ->findOneById($request->query->getInt('user'))
        ;

        // Przypisanie do zmiennej repozytorium transakcji.
        $transactionRepository = $em->getRepository('WiBidbeeWalletBundle:Transaction');

        // Pobranie liczby wszystkich transakcji.
        $recordsTotal = $transactionRepository->countByUser($user);

        // Pobranie liczby wszystkich wyfiltrowanych transakcji.
        $recordsFiltered = $transactionRepository->countByUserSearchResults($user, $search['value']);

        // Pobranie transakcji użytkownika.
        $transactions = $transactionRepository->searchByUser(
            $user,
            $search['value'],
            [
                $columns[$order[0]['column']]['data'] => $order[0]['dir']
            ],
            $length,
            $start
        );

        $data = [];

        // Przetworzenie danych i przekazanie do widoku.
        foreach ($transactions as $transaction) {
            $data[] = [
                'id' => $transaction->getId(),
                'dateCreated' => $transaction->getDateCreated()->format('Y-m-d H:i:s'),
                'virtualCurrencyQuantity' => $transaction->getVirtualCurrencyQuantity(),
                'price' => $transaction->getPrice(),
                'status' => $transaction->getStatus(),
                'virtualCurrencyName' => $transaction->getVirtualCurrency()->getName(),
            ];
        }

        return new JsonResponse([
            'draw' => $draw,
            'recordsTotal' => $recordsTotal,
            'recordsFiltered' => $recordsFiltered,
            'data' => $data,
        ]);
    }

    /**
     * Get user virtual transaction list for datatables.
     *
     * @param   Request         $request
     * @return  JsonResponse
     */
    public function virtualTransactionAction(Request $request)
    {
        $search = $request->query->get('search');
        $draw = $request->query->getInt('draw');
        $start = $request->query->getInt('start');
        $length = $request->query->getInt('length');
        $columns = $request->query->get('columns');
        $order = $request->query->get('order');

        // Utworzenie instancji EntityManager-a.
        $em = $this->getDoctrine()->getManager();

        // Pobranie użytkownika.
        $user = $em->getRepository('WiAdminUserBundle:User')
            ->findOneById($request->query->getInt('user'))
        ;

        // Przypisanie do zmiennej repozytorium wirtualnych transakcji.
        $virtualTransactionRepository = $em->getRepository('WiBidbeeWalletBundle:VirtualTransaction');

        // Pobranie liczby wszystkich wirtualnych transakcji.
        $recordsTotal = $virtualTransactionRepository->countByUser($user);

        // Pobranie liczby wszystkich wyfiltrowanych wirtualnych transakcji.
        $recordsFiltered = $virtualTransactionRepository->countByUserSearchResults($user, $search['value']);

        // Pobranie wirtualnych transakcji użytkownika.
        $virtualTransactions = $virtualTransactionRepository->searchByUser(
            $user,
            $search['value'],
            [
                $columns[$order[0]['column']]['data'] => $order[0]['dir']
            ],
            $length,
            $start
        );

        $data = [];

        // Przetworzenie danych i przekazanie do widoku.
        foreach ($virtualTransactions as $virtualTransaction) {
            $data[] = [
                'id' => $virtualTransaction->getId(),
                'dateCreated' => $virtualTransaction->getDateCreated()->format('Y-m-d H:i:s'),
                'amount' => $virtualTransaction->getAmount(),
                'virtualCurrencyName' => $virtualTransaction->getVirtualCurrency()->getName(),
                'virtualTransactionType' => $virtualTransaction->getVirtualTransactionType()->getName(),
            ];
        }

        return new JsonResponse([
            'draw' => $draw,
            'recordsTotal' => $recordsTotal,
            'recordsFiltered' => $recordsFiltered,
            'data' => $data,
        ]);
    }
}
