<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_pages_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.pagesGroup.New')) ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/select2/dist/css/select2.min.css') ?>" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/pages.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"/>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.content'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_pages_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.pages.pages'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_page_groups_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.pagesGroup.List'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_page_groups_new'); ?>"><?php echo $view['translator']->trans('breadcrumbs.pagesGroup.Add'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <i class="icon-doc-text-1"></i><?php echo $view['translator']->trans('pages.listTitle'); ?> - <?php echo $view['translator']->trans('groupNew.subTitle'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('groupNew.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title"><i class="icon-folder-add"></i>
                <span><?php echo $view['translator']->trans('groupNew.listSubTitle'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('groupNew.formTitle'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('groupNew.formDesc'); ?></p>
                </div>
                <div class="large-10 columns">
                    <?php if ($view['form']->errors($form)): ?>
                        <div class="alert callout small">
                            <?php echo $view['form']->errors($form); ?>
                        </div>
                    <?php endif; ?>

                    <?php echo $view['form']->start($form) ?>
                    <div class="row">
                        <div class="medium-12 large-6 columns end">
                            <?php echo $view['form']->label($form['name']) ?>
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['name']) ?>
                            </div>
                            <?php echo($view['form']->errors($form['name']) ? $view['form']->widget($form['name'], array('attr' => array('class' => 'callout alert'))) : $view['form']->widget($form['name'])) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="small-6 medium-4 large-2 columns end">
                            <?php echo $view['form']->label($form['orderNr']) ?>
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['orderNr']) ?>
                            </div>
                            <?php echo($view['form']->errors($form['orderNr']) ? $view['form']->widget($form['orderNr'], array('attr' => array('class' => 'callout alert'))) : $view['form']->widget($form['orderNr'])) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="medium-12 large-6 columns end">
                            <?php echo $view['form']->label($form['parent']) ?>
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['parent']) ?>
                            </div>
                            <?php echo($view['form']->errors($form['parent']) ? $view['form']->widget($form['parent'], array('attr' => array('class' => 'callout alert chosenSelectGroup'))) : $view['form']->widget($form['parent'])) ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                </div>
                <div class="large-10 columns">
                    <div class="wi-konatkt-form">
                        <button class="button" href="#" type="submit" value="<?php echo $view['translator']->trans('Form.create'); ?>">
                            <i class="icon-plus"></i> <?php echo $view['translator']->trans('Form.create'); ?>
                        </button>
                        <?php echo $view['form']->end($form) ?>
                        <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_page_groups_index'); ?>">
                            <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/select2/dist/js/select2.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/pages.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop(); ?>
