<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_pages_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.pagesGroup.Delete')) ?>

<?php $view['slots']->start('stylesheets') ?>
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/pages.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"/>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.content'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_pages_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.pages.pages'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_page_groups_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.pagesGroup.List'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_page_groups_delete', ['id' => $pageGroup->getId()]); ?>"><?php echo $view['translator']->trans('breadcrumbs.pagesGroup.Delete'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <i class="icon-doc-text-1"></i>
    <?php echo $view['translator']->trans('pages.listTitle'); ?> - <?php echo $view['translator']->trans('groupDelete.subTitle'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('groupDelete.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php // Funkcja wyświetlająca dzieci kategorii ?>
<?php function getChildrenView($group, $view) { ?>
    <ul class="childrenView">
        <?php foreach ($group as $children): ?>
            <li>
                <?php echo $children->getName().' - '.$children->getPages()->count().' '.$view['translator']->trans('groupDelete.countPages'); ?>
                <?php getChildrenView($children->getChildren(), $view); ?>
            </li>
        <?php endforeach; ?>
    </ul>
<?php } ?>

<?php $view['slots']->start('body'); ?>
    <div class="box">
        <div class="box-header bg-transparent" data-widget="collapse">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span class="box-btn"><i class="icon-window"></i></span>
            </div>
            <h3 class="box-title" data-widget="collapse"><i class="icon-folder-delete"></i>
                <span><?php echo $view['translator']->trans('groupDelete.listSubTitle'); ?> - <?php echo $pageGroup->getName() ?> </span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <?php echo $view['form']->start($formDelete); ?>
                <p class="groupDeleteQuestion"><?php echo $view['translator']->trans('groupDelete.confirm'); ?></p>
                <div class="switch-admin">
                    <?php echo $view['form']->errors($formDelete['deletePageGroup']); ?>
                    <?php echo $view['form']->widget($formDelete['deletePageGroup']); ?>
                    <label class="switch-paddle" for="<?php echo $formDelete->children['deletePageGroup']->vars['id']; ?>">
                        <span class="show-for-sr"><?php echo $view['translator']->trans('groupDelete.confirm'); ?></span>
                        <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                        <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                    </label>
                </div>
                <span id="countPages"  wartosc="<?php echo $pageGroup->getPages()->count() ?>"></span>
                <span id="countChildren"  wartosc="<?php echo $pageGroup->getChildren()->count() ?>"></span>
                <div class="confirmDelete" id="confirmDelete">
                    <?php if($pageGroup->getPages()->count()!=0 || $pageGroup->getChildren()->count()!=0): ?>
                        <p><?php echo $view['translator']->trans('groupDelete.listPages').' '.$pageGroup->getPages()->count().' '.$view['translator']->trans('groupDelete.countPages') ; ?></p>
                        <?php if($pageGroup->getChildren()->count() > 0): ?>
                            <p class="groupDeleteQuestion"><?php echo $view['translator']->trans('groupDelete.listChildren') ?>:</p>
                            <?php getChildrenView($pageGroup->getChildren(), $view); ?>
                        <?php endif; ?>
                        <p class="groupDeleteQuestion"><?php echo $view['translator']->trans('groupDelete.confirmSubtacegories'); ?></p>
                        <div class="switch-admin">
                            <?php echo $view['form']->errors($formDelete['deleteAll']); ?>
                            <?php echo $view['form']->widget($formDelete['deleteAll']); ?>
                            <label class="switch-paddle" for="<?php echo $formDelete->children['deleteAll']->vars['id']; ?>">
                                <span class="show-for-sr"><?php echo $view['translator']->trans('groupDelete.confirmSubtacegories'); ?></span>
                                <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                                <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                            </label>
                        </div>
                        <div class="confirmDeleteSubcategories" id="confirmDeleteSubcategories">
                            <div class="selectGroup" id="selectGroup">
                                <p class="groupDeleteQuestion"><?php echo $view['translator']->trans('groupDelete.changeSubtacegories'); ?></p>
                                <div class="newGroupSelect">
                                    <?php echo $view['form']->errors($formDelete['newPageGroup']); ?>
                                    <?php echo $view['form']->widget($formDelete['newPageGroup']); ?>
                                </div>
                            </div>
                        </div>
                        <?php echo $view['form']->errors($formDelete); ?>
                        <?php echo $view['form']->widget($formDelete); ?>
                    <?php else: ?>
                        <p><?php echo $view['translator']->trans('groupDelete.listPages').' '.$pageGroup->getPages()->count().' '.$view['translator']->trans('groupDelete.countPages') ; ?></p>
                    <?php endif; ?>
                    <button type="submit" id="groupDeleteInput" class="button alert tiny" value="<?php echo $view['translator']->trans('Form.delete'); ?>" disabled>
                        <i class="icon-cancel-circled"></i> <?php echo $view['translator']->trans('adminDelete.delete'); ?>
                    </button>
                </div>
            <?php echo $view['form']->end($formDelete); ?>
            <div class="row navigationBottom">
                <div class="columns">
                    <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_page_groups_show', array('id' => $pageGroup->getId())); ?>">
                        <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/pages.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>

