<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_pages_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.pages.New')) ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/select2/dist/css/select2.min.css') ?>" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/pages.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"/>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.content'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_pages_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.pages.pages'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_pages_new'); ?>"><?php echo $view['translator']->trans('breadcrumbs.pages.New'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <i class="icon-doc-text-1"></i><?php echo $view['translator']->trans('pages.listTitle'); ?> - <?php echo $view['translator']->trans('pagesNew.subTitle'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('pagesNew.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>
    <?php echo $view['form']->start($form, ['attr' => ['id' => 'wi_admin_pagebundle_page']]); ?>
        <div class="box">
            <div class="box-header bg-transparent">
                <!-- tools box -->
                <h3 class="box-title">
                    <i class="icon-doc-add"></i> <span><?php echo $view['translator']->trans('pagesNew.boxTitle'); ?></span>
                </h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body " style="display: block;">
                <div class="row">
                    <div class="large-2 columns">
                        <p><strong><?php echo $view['translator']->trans('pagesNew.form.titleTitle'); ?></strong></p>
                        <p><?php echo $view['translator']->trans('pagesNew.form.titleDesc'); ?></p>
                    </div>
                    <div class="large-10 columns">
                        <div class="row">
                            <div class="medium-6 columns end">
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($form['title']); ?>
                                </div>
                                <?php echo ($view['form']->errors($form['title']) ? $view['form']->widget($form['title'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['title'])); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="large-2 columns">
                        <p><strong><?php echo $view['translator']->trans('pagesNew.form.textTitle'); ?></strong></p>
                        <p><?php echo $view['translator']->trans('pagesNew.form.textDesc'); ?></p>
                    </div>
                    <div class="large-10 columns">
                        <div class="row">
                            <div class="columns">
                                <div class="formAlert <?php echo ($view['form']->errors($form['content']) ? "callout alert" : ""); ?>">
                                    <?php echo $view['form']->errors($form['content']); ?>
                                </div>
                                <div class="formAlert callout alert" id="contentValidation">
                                    <?php echo $view['translator']->trans('This value should not be blank.'); ?>
                                </div>
                                <?php echo $view['form']->widget($form['content']); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="large-2 columns">
                        <p><strong><?php echo $view['translator']->trans('pagesNew.form.groupTitle'); ?></strong></p>
                        <p><?php echo $view['translator']->trans('pagesNew.form.groupDesc'); ?></p>
                    </div>
                    <div class="large-10 columns">
                        <div class="row">
                            <div class="medium-6 columns">
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($form['group']); ?>
                                </div>
                                <?php echo ($view['form']->errors($form['group']) ? $view['form']->widget($form['group'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['group'])); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="box metaTags collapsed-box">
            <div class="box-header bg-transparent">
                <!-- tools box -->
                <div class="pull-right box-tools">
                    <span>
                        <i class="icon-up-open" data-widget="collapse"></i>
                    </span>
                </div>
                <h3 class="box-title" data-widget="collapse">
                    <i class="icon-chart-bar-2"></i> <span><?php echo $view['translator']->trans('pagesNew.metaTitle'); ?></span>
                </h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body " style="display: none;">
                <div class="row">
                    <div class="large-2 columns">
                        <p><strong><?php echo $view['translator']->trans('pagesNew.form.metaTitle'); ?></strong></p>
                        <p><?php echo $view['translator']->trans('pagesNew.form.metaDesc'); ?></p>
                    </div>
                    <div class="large-10 columns">
                        <div class="row">
                            <div class="medium-6 columns end">
                                <div class="news-add-form">
                                    <?php echo $view['form']->label($form['metaTitle']) ?>
                                    <div class="formAlert">
                                        <?php echo $view['form']->errors($form['metaTitle']); ?>
                                    </div>
                                    <?php echo ($view['form']->errors($form['metaTitle']) ? $view['form']->widget($form['metaTitle'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['metaTitle'])); ?>
                                </div>
                                <div class="news-add-form">
                                    <?php echo $view['form']->label($form['metaDescription']) ?>
                                    <div class="formAlert">
                                        <?php echo $view['form']->errors($form['metaDescription']); ?>
                                    </div>
                                    <?php echo ($view['form']->errors($form['metaDescription']) ? $view['form']->widget($form['metaDescription'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['metaDescription'])); ?>
                                </div>
                                <div class="news-add-form">
                                    <?php echo $view['form']->label($form['metaKeywords']) ?>
                                    <div class="formAlert">
                                        <?php echo $view['form']->errors($form['metaKeywords']); ?>
                                    </div>
                                    <?php echo ($view['form']->errors($form['metaKeywords']) ? $view['form']->widget($form['metaKeywords'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['metaKeywords'])); ?>
                                </div>
                                <div class="news-add-form">
                                    <?php echo $view['form']->label($form['metaCanonical']) ?>
                                    <div class="formAlert">
                                        <?php echo $view['form']->errors($form['metaCanonical']); ?>
                                    </div>
                                    <?php echo ($view['form']->errors($form['metaCanonical']) ? $view['form']->widget($form['metaCanonical'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['metaCanonical'])); ?>
                                </div>
                                <div class="news-add-form">
                                    <?php echo $view['form']->label($form['metaImage']) ?>
                                    <div class="formAlert">
                                        <?php echo $view['form']->errors($form['metaImage']); ?>
                                    </div>
                                    <?php echo ($view['form']->errors($form['metaImage']) ? $view['form']->widget($form['metaImage'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['metaImage'])); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="box">
            <div class="box-body " style="display: block;">
                <div class="row">
                    <div class="large-2 columns">
                    </div>
                    <div class="large-10 columns">
                        <div class="news-add-form">
                            <?php echo $view['form']->widget($form); ?>
                            <button class="button" type="submit" value="<?php echo $view['translator']->trans('Form.create'); ?>">
                                <i class="icon-plus"></i> <?php echo $view['translator']->trans('Form.create'); ?>
                            </button>

                            <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_pages_index'); ?>">
                                <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>


    <?php echo $view['form']->end($form); ?>
<?php echo $view->render('Components/modalTinyMCE.html.php') ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/plupload.full.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/i18n/'.$view['request']->getLocale().'.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/select2/dist/js/select2.min.js') ?>" type="text/javascript"></script>
    <script src='<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/tinymce/tinymce.min.js') ?>'></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/pages.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/tinyMCE/tinyMCE.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>

