<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_pages_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.pages.List')) ?>

<?php $view['slots']->start('stylesheets') ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css') ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css') ?>"  rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/pages.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"  rel="stylesheet" type="text/css" />
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.content'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_pages_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.pages.pages'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <i class="icon-doc-text-1"></i><?php echo $view['translator']->trans('pages.listTitle'); ?> - <?php echo $view['translator']->trans('pagesList.subTitle'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('pagesList.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>
    <?php
    /**
     * Render page groups tree.
     *
     * @return string
     */
    $displayPageGroupsWithPages = function ($pageGroups, $prefix = '', $html = '') use (&$displayPageGroupsWithPages, $view) {
        foreach ($pageGroups as $key => $pageGroup) {
            $html .= '
                <div class="boxPagesGroup box '. (($pageGroup->getId()==1 && is_null($view['request']->getParameter('q')))? "collapsed-box" : "") .'">
                    <div class="box-header bg-transparent">
                        <div class="pull-right box-tools">
                            <span class="box-btn"  data-toggle="configPagesGroup' . $pageGroup->getId() . '-dropdown">
                                <i class="icon-cog-5"></i>
                            </span>
                            <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configPagesGroup' . $pageGroup->getId() . '-dropdown" data-dropdown data-close-on-click="true">
                                <ul class="no-bullet">
                                    <li>
                                        <a href="'.$view['router']->path('wi_admin_page_groups_show', ['id' => $pageGroup->getId()]).'" title="'.$view['translator']->trans('pagesList.showGroup').'">
                                            <span><i class="icon-folder-2"></i>'.$view['translator']->trans('pagesList.showGroup').'</span>
                                        </a>
                                    </li>';
                                    if($view['security']->isGranted('ROLE_PAGES_EDIT') && $pageGroup->getId()!=1){
                                        $html .= '<li>
                                            <a href="'.$view['router']->path('wi_admin_pages_new', ['page_group_id' => $pageGroup->getId()]).'" title="'.$view['translator']->trans('pagesList.addInGr').'">
                                                <span><i class="icon-doc-add"></i>'.$view['translator']->trans('pagesList.addInGr').'</span>
                                            </a>
                                            </li>
                                        ';
                                    }
                             $html .=   '
                                <li class="odciecie">
                                <button class="collapseAll" type="button">
                                    <span><i class="icon-collapse"></i> '.$view['translator']->trans('pagesList.collapse').'</span>
                                    </button> /
                                    <button class="expandAll" type="button">
                                        <span><i class="icon-expand"></i> '.$view['translator']->trans('pagesList.expand').'</span>
                                    </button>
                                </li>
                            </ul>
                            </div>
                            <span>
                            <i class="icon-up-open collapseExpand" data-widget="collapse"></i>
</span>
                        </div>
                        <h3 class="box-title" data-widget="collapse"><i class="icon-folder"></i>
                            <span>'.$prefix.$pageGroup->getName().'</span>
                        </h3>
                        <input type="text" class="searchThisGroup" data-table="pagesGroupTable' . $key . '" placeholder="'. $view['translator']->trans('pagesList.searchInGroup') .'">


                    </div>
                    <div class="box-body" style="display: '. (($pageGroup->getId()==1 && is_null($view['request']->getParameter('q')))? "none" : "block") .';">

            ';

            if ($pageGroup->getPages()->count()) {
                $html .= '
                    <br>
                    <div class="row">
                    <div class="columns tableResp">
                        <table class="hover pagesGroupTable' . $key . ' pagesGroupTable">
                            <thead>
                                <tr>
                                    <th>'.$view['translator']->trans('pagesList.table.id').'</th>
                                    <th>'.$view['translator']->trans('pagesList.table.title').'</th>
                                    <th>'.$view['translator']->trans('pagesList.table.short').'</th>
                                    <th>'.$view['translator']->trans('pagesList.table.date').'</th>
                                </tr>
                            </thead>
                            <tbody>
                    ';

                    foreach ($pageGroup->getPages() as $page) {
                        if (! empty($view['request']->getParameter('q'))) {
                            if (
                                mb_strpos(strtolower($page->getTitle()), strtolower($view['request']->getParameter('q'))) === FALSE
                                && mb_strpos(strtolower($page->getContent()), strtolower($view['request']->getParameter('q'))) === FALSE
                            ) {
                                continue;
                            }
                        }
                        $html .= '
                            <tr>
                                <td>'.$page->getId().'

                                </td>
                                <td><a href="'.$view['router']->path('wi_admin_pages_show', array('id' => $page->getid())).'" title="'.$view['translator']->trans('pagesList.showNews').'"><b> '.$page->getTitle().' </b></a>
                                <div class="buttonItemsBox">
                                    <div class="buttonsItems">
                                        <a href="'. $view['router']->path('wi_admin_pages_show', ['id' => $page->getId()]) .'" class=""><i class="icon-eye-1"></i>'. $view['translator']->trans('Table.showButton') .'</a> / ';
                                if ($view['security']->isGranted('ROLE_PAGES_EDIT')){
                                    $html .= '<a href="' .$view['router']->path('wi_admin_pages_edit', ['id' => $page->getId()]) .'" class=""><i class="icon-edit-1"></i>' .$view['translator']->trans('Table.editButton'). '</a> / ';
                                }
                                if ($view['security']->isGranted('ROLE_PAGES_EDIT') && $pageGroup->getId() != 1){
                                    $html .= '<a href="' .$view['router']->path('wi_admin_pages_delete', ['id' => $page->getId()]). '" class=""><i class="icon-cancel-circled-outline"></i>' .$view['translator']->trans('Table.deleteButton'). '</a>';
                                }

                        $html .=    '</div></div>
                                </td>
                                <td>'. substr(trim(strip_tags($page->getContent())),0,200).(strlen(trim(strip_tags($page->getContent())))>200 ? "..." : "").'</td>
                                <td>'.$page->getDateCreated()->format('Y-m-d').'</td>
                            </tr>
                        ';
                    }

                    $html .= '
                            </tbody>
                        </table>
                        </div>
                    </div>
                ';
            }
            $html .= '

                </div>
                </div>
            ';

            // Jeśli są podgrupy.
            if ($pageGroup->getChildren()->count()) {
                $html .= $displayPageGroupsWithPages($pageGroup->getChildren(), $prefix . $pageGroup->getName() . ' > ');
            }
        }

        return $html;
    };
    ?>

    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span class="box-btn" data-toggle="configGroup-dropdown">
                    <i class="icon-cog-5"></i>
                </span>
                <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="left" id="configGroup-dropdown" data-dropdown data-close-on-click="true">
                    <ul class="no-bullet">
                        <li>
                            <?php if ($view['security']->isGranted('ROLE_PAGES_EDIT')): ?>
                                <a href="<?php echo $view['router']->path('wi_admin_page_groups_new') ?>" title="<?php echo $view['translator']->trans('pagesList.addNewGroup'); ?>">
                                    <span><i class="icon-folder-add"></i><?php echo $view['translator']->trans('pagesList.addNewGroup'); ?></span>
                                </a>
                            <?php endif; ?>
                        </li>
                        <li>
                            <a href="<?php echo $view['router']->path('wi_admin_page_groups_index') ?>" title="<?php echo $view['translator']->trans('pagesList.menageGroup'); ?>">
                                <span><i class="icon-folder-2"></i><?php echo $view['translator']->trans('pagesList.menageGroup'); ?></span>
                            </a>
                        </li>
                        <li>
                            <?php if ($view['security']->isGranted('ROLE_PAGES_EDIT')): ?>
                                <a href="<?php echo $view['router']->path('wi_admin_pages_new') ?>" title="<?php echo $view['translator']->trans('pagesList.add'); ?>">
                                    <span><i class="icon-doc-add"></i><?php echo $view['translator']->trans('pagesList.add'); ?></span>
                                </a>
                            <?php endif; ?>
                        </li>
                    </ul>
                </div>
            </div>
            <h3 class="box-title"><i class="icon-search"></i>
                <span><?php echo $view['translator']->trans('pagesList.searchBox'); ?>:</span>
            </h3>
            <form action="<?php echo $view['router']->path('wi_admin_pages_index'); ?>" method="get" id="searchBoxForm">
                <input type="search" name="q" value="<?php echo $view['request']->getParameter('q'); ?>" placeholder="<?php echo $view['translator']->trans('pagesList.search'); ?>">
            </form>
            <?php if(! is_null($view['request']->getParameter('q'))): ?>
                <a class="clearFilter" href="<?php echo $view['router']->path('wi_admin_pages_index') ?>" title="<?php echo $view['translator']->trans('newsList.clearFilter'); ?>"><i class="icon-cancel"></i></a>
            <?php endif; ?>
        </div>
    </div>
<span class="countPagesGroups" date-pageGroups="<?php echo $pageGroups->count(); ?>"></span>
    <?php echo $displayPageGroupsWithPages($pageGroups); ?>
    <script>
        var language = '<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery/dataTables/i18n/'.$view['request']->getLocale().'.json'); ?>';
    </script>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/jquery.tooltipster.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/pages.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
