<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_pages_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.pages.Edit')) ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/select2/dist/css/select2.min.css') ?>" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/pages.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"/>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.content'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_pages_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.pages.pages'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_pages_edit', array('id' => $page->getId())); ?>"><?php echo $view['translator']->trans('breadcrumbs.pages.Edit'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <i class="icon-doc-text-1"></i><?php echo $view['translator']->trans('pages.listTitle'); ?> - <?php echo $view['translator']->trans('pagesEdit.subTitle'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('pagesEdit.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('menuShowSite'); ?>
<div class="menu-show-site">
    <a  class="button success tiny" href="<?php echo $view['router']->path('wi_front_page_index', ['id' => $page->getId(), 'slug' => $view['front']->slugify($page->getTitle())]); ?>" title="<?php echo $view['translator']->trans('top-bar.showArticle'); ?>" target="_blank">
        <i class="icon-monitor-1"></i>
        <span>
                <?php echo $view['translator']->trans('top-bar.showArticle'); ?>
            </span>
    </a>
</div>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>
<?php echo $view['form']->start($edit_form, ['attr' => ['id' => 'wi_admin_pagebundle_page']]); ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title">
                <i class="icon-edit"></i> <span><?php echo $view['translator']->trans('pagesEdit.boxTitle'); ?> - <?php echo $page->getTitle(); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('pagesEdit.form.titleTitle'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('pagesEdit.form.titleDesc'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($edit_form['title']); ?>
                            </div>
                            <?php echo ($view['form']->errors($edit_form['title']) ? $view['form']->widget($edit_form['title'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($edit_form['title'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('pagesEdit.form.textTitle'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('pagesEdit.form.textDesc'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="columns">
                            <div class="formAlert <?php echo ($view['form']->errors($edit_form['content']) ? "callout alert" : ""); ?>">
                                <?php echo $view['form']->errors($edit_form['content']); ?>
                            </div>
                            <div class="formAlert callout alert" id="contentValidation">
                                <?php echo $view['translator']->trans('This value should not be blank.'); ?>
                            </div>
                            <?php echo $view['form']->widget($edit_form['content']); ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php if(isset($edit_form['group'])): ?>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('pagesEdit.form.groupTitle'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('pagesEdit.form.groupDesc'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($edit_form['group']); ?>
                            </div>
                            <?php echo ($view['form']->errors($edit_form['group']) ? $view['form']->widget($edit_form['group'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($edit_form['group'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
    <div class="box metaTags collapsed-box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span>
                    <i class="icon-up-open" data-widget="collapse"></i>
                </span>
            </div>
            <h3 class="box-title" data-widget="collapse">
                <i class="icon-chart-bar-2"></i> <span><?php echo $view['translator']->trans('pagesEdit.metaTitle'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: none;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('pagesEdit.form.metaTitle'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('pagesEdit.form.metaDesc'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <div class="news-add-form">
                                <?php echo $view['form']->label($edit_form['metaTitle']) ?>
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($edit_form['metaTitle']); ?>
                                </div>
                                <?php echo ($view['form']->errors($edit_form['metaTitle']) ? $view['form']->widget($edit_form['metaTitle'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($edit_form['metaTitle'])); ?>
                            </div>
                            <div class="news-add-form">
                                <?php echo $view['form']->label($edit_form['metaDescription']) ?>
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($edit_form['metaDescription']); ?>
                                </div>
                                <?php echo ($view['form']->errors($edit_form['metaDescription']) ? $view['form']->widget($edit_form['metaDescription'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($edit_form['metaDescription'])); ?>
                            </div>
                            <div class="news-add-form">
                                <?php echo $view['form']->label($edit_form['metaKeywords']) ?>
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($edit_form['metaKeywords']); ?>
                                </div>
                                <?php echo ($view['form']->errors($edit_form['metaKeywords']) ? $view['form']->widget($edit_form['metaKeywords'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($edit_form['metaKeywords'])); ?>
                            </div>
                            <div class="news-add-form">
                                <?php echo $view['form']->label($edit_form['metaCanonical']) ?>
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($edit_form['metaCanonical']); ?>
                                </div>
                                <?php echo ($view['form']->errors($edit_form['metaCanonical']) ? $view['form']->widget($edit_form['metaCanonical'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($edit_form['metaCanonical'])); ?>
                            </div>
                            <div class="news-add-form">
                                <?php echo $view['form']->label($edit_form['metaImage']) ?>
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($edit_form['metaImage']); ?>
                                </div>
                                <?php echo ($view['form']->errors($edit_form['metaImage']) ? $view['form']->widget($edit_form['metaImage'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($edit_form['metaImage'])); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="box">
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-2 columns">
                </div>
                <div class="large-10 columns">
                    <div class="news-add-form">
                        <?php echo $view['form']->widget($edit_form); ?>
                        <button class="button" href="#" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>">
                            <i class="icon-edit"></i>
                            <?php echo $view['translator']->trans('Form.send'); ?>
                        </button>
                        <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_pages_show', array('id' => $page->getId())); ?>">
                            <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php echo $view['form']->end($edit_form); ?>
<?php echo $view->render('Components/modalTinyMCE.html.php') ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/plupload.full.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/i18n/'.$view['request']->getLocale().'.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/select2/dist/js/select2.min.js') ?>" type="text/javascript"></script>
    <script src='<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/tinymce/tinymce.min.js') ?>'></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/pages.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/tinyMCE/tinyMCE.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>

