<?php

namespace Wi\Admin\PageBundle\Form;

use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Wi\Admin\PageBundle\Entity\Page;

/**
 * Page Group Delete Listener.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class PageType extends AbstractType
{
    /**
     * @var EntityManagerInterface
     */
    private $em;

    /**
     * Construct.
     *
     * @param EntityManagerInterface $em
     */
    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }

    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('title', TextType::class, [
                'attr' => [
                    'maxlength' => 256,
                    'placeholder' => 'pagesNew.form.titleTitle',
                ],
                'label' => 'pagesNew.form.titleTitle',
            ])
            ->add('content', TextareaType::class, [
                'attr' => [
                    'maxlength' => 65535,
                    'rows' => 10,
                    'class' => 'tinyMCE',
                ],
                'label' => 'Content',
                'required' => false,
            ])
            ->add('metaTitle', TextType::class, [
                'attr' => [
                    'maxlength' => 256,
                    'placeholder' => 'pagesNew.form.placeMetaTitle',
                ],
                'label' => 'pagesNew.form.titleMetaTitle',
                'required' => false,
            ])
            ->add('metaDescription', TextType::class, [
                'attr' => [
                    'maxlength' => 512,
                    'placeholder' => 'pagesNew.form.placeMetaDescription',
                ],
                'label' => 'pagesNew.form.titleMetaDescription',
                'required' => false,
            ])
            ->add('metaKeywords', TextType::class, [
                'attr' => [
                    'maxlength' => 256,
                    'placeholder' => 'pagesNew.form.placeMetaKeywords',
                ],
                'label' => 'pagesNew.form.titleMetaKeywords',
                'required' => false,
            ])
            ->add('metaCanonical', TextType::class, [
                'attr' => [
                    'maxlength' => 512,
                    'placeholder' => 'pagesNew.form.placeMetaCanonical',
                ],
                'label' => 'pagesNew.form.titleMetaCanonical',
                'required' => false,
            ])
            ->add('metaImage', TextType::class, [
                'attr' => [
                    'maxlength' => 256,
                    'placeholder' => 'pagesNew.form.placeMetaImage',
                ],
                'label' => 'pagesNew.form.titleMetaImage',
                'required' => false,
            ])
        ;
        $id = $builder->getData()->getId();
        if ($id > 20 || is_null($id))
        {
            $builder
                ->add('group', ChoiceType::class, [
                'attr' => [
                    'class' => 'chosenSelectGroup',
                ],
                'choice_label' => function ($value, $key, $index) {
                    return $value->label;
                },
                'choice_translation_domain' => false,
                'choices' => $this->getChoices(),
                'required' => true,
            ]);
        }
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => Page::class,
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'wi_admin_pagebundle_page';
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Przetwarza grupy stron i generuje z nich drzewo.
     *
     * @return PageGroup[]
     */
    private function getChoices()
    {
        $choices = [];

        // Pobranie wszystkich głównych, aktywnych grup stron.
        $pageGroups = $this->em->getRepository('WiAdminPageBundle:PageGroup')
            ->findAllActiveWithoutParent()
        ;

        /**
         * Przetwarza drzewo zagnieżdżeń kategorii i wypisuje do selecta.
         *
         * @param   PageGroup[] $pageGroups
         * @param   string      $prefix
         */
        $createTree = function ($pageGroups, $prefix = '') use (&$createTree, &$choices) {
            foreach ($pageGroups as $pageGroup) {
                // Pole label jest tworzone dynamicznie tylko na potrzeby wypisania etykiety.
                $pageGroup->label = $prefix . $pageGroup->getName();
                $choices[] = $pageGroup;

                if ($pageGroup->getChildren()->count()) {
                    $createTree($pageGroup->getChildren(), $prefix . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;');
                }
            }

        };

        $createTree($pageGroups);

        return $choices;
    }
}
