<?php

namespace Wi\Admin\PageBundle\Form;

use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Wi\Admin\PageBundle\Entity\PageGroup;

/**
 * Page Group Delete Listener.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class PageGroupDeleteType extends AbstractType
{
    /**
     * @var EntityManagerInterface
     */
    private $em;

    /**
     * Construct.
     *
     * @param EntityManagerInterface $em
     */
    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }

    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('deletePageGroup', CheckboxType::class, [
                'attr' => [
                     'class' => 'switch-input',
                ],
                'mapped' => false,
                'required' => true,
            ])
        ;

        if ($options['data']->getPages()->count() || $options['data']->getChildren()->count()) {
            $builder
                ->add('deleteAll', CheckboxType::class, [
                    'attr' => [
                         'class' => 'switch-input',
                    ],
                    'mapped' => false,
                    'required' => false,
                ])
                ->add('newPageGroup', ChoiceType::class, [
                    'choice_attr' => function ($value, $key, $index) use ($options) {
                        if ($options['data']->getId() == $value->getId()) {
                            return ['disabled' => true];
                        }

                        $children = [];

                        $setDisabled = function ($pageGroups) use (&$setDisabled, &$children) {
                            foreach ($pageGroups as $pageGroup) {
                                $children[] = $pageGroup->getId();

                                if ($pageGroup->getChildren()->count()) {
                                    $setDisabled($pageGroup->getChildren());
                                }
                            }
                        };

                        $setDisabled($options['data']->getChildren());

                        if (in_array($value->getId(), $children)) {
                            return ['disabled' => true];
                        }

                        return [];
                    },
                    'choice_label' => function ($value, $key, $index) {
                        return $value->label;
                    },
                    'choice_translation_domain' => false,
                    'choices' => $this->getChoices(),
                    'mapped' => false,
                    'placeholder' => 'groupDelete.newGroup',
                    'required' => false,
                ])
            ;
        }
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => PageGroup::class,
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return '';
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Przetwarza grupy stron i generuje z nich drzewo.
     *
     * @return PageGroup[]
     */
    private function getChoices()
    {
        $choices = [];

        // Pobranie wszystkich głównych, aktywnych grup stron.
        $pageGroups = $this->em->getRepository('WiAdminPageBundle:PageGroup')
            ->findAllActiveWithoutParent()
        ;

        /**
         * Przetwarza drzewo zagnieżdżeń kategorii i wypisuje do selecta.
         *
         * @param   PageGroup[] $pageGroups
         * @param   string      $prefix
         */
        $createTree = function ($pageGroups, $prefix = '') use (&$createTree, &$choices) {
            foreach ($pageGroups as $pageGroup) {
                // Pole label jest tworzone dynamicznie tylko na potrzeby wypisania etykiety.
                $pageGroup->label = $prefix . $pageGroup->getName();
                $choices[] = $pageGroup;

                if ($pageGroup->getChildren()->count()) {
                    $createTree($pageGroup->getChildren(), $prefix . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;');
                }
            }

        };

        $createTree($pageGroups);

        return $choices;
    }
}
