<?php

namespace Wi\Admin\NewsLetterBundle\User;

use Doctrine\ORM\EntityManagerInterface;
use Wi\Admin\NewsLetterBundle\Entity\Recipients;
use Wi\Admin\UserBundle\Entity\User;

/**
 * Register user manager to newsletter recipient group.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2018 WEBimpuls Sp. z o.o.
 */
class RegisterUserManager
{
    /**
     * @var EntityManagerInterface
     */
    private $em;

    /**
     * Constructor.
     *
     * @param EntityManagerInterface $em
     */
    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }

    /**
     * Aktualizacja odbiorcy na podstawie danych użytkownika.
     *
     * @param User $user
     */
    public function changeSubscribe(User $user)
    {
        $recipient = $this->em->getRepository('WiAdminNewsLetterBundle:Recipients')->findOneByEmailInRegisterUsersGroup($user->getEmail());

        if (! $recipient && ! empty($user->getEmail())) {
            $recipient = new Recipients();
            $recipient
                ->setRecipientGroup($this->em->getRepository('WiAdminNewsLetterBundle:RecipientGroup')->find(1))
                ->setEmail($user->getEmail())
            ;
        }

        $recipient->setConsent(intval($user->getAllowNewsletter()));

        $this->em->persist($recipient);
        $this->em->flush($recipient);
    }
}
