<?php

namespace Wi\Admin\NewsLetterBundle\Service;

use Symfony\Component\Routing\RouterInterface;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

class SignUpCodeGenerator
{
    private $router;

    public function __construct(RouterInterface $router)
    {
        $this->router = $router;
    }

    public function generate(string $id, bool $addName = false) : string
    {
        $name = '';

        if ($addName) {
            $name = '<div class="wi-newsletter-field">
                <label for="name">Imię:</label>
                <input type="text" name="name" required>
            </div>';
        }

        $code = '<div class="wi-newsletter">
            <form action="'.$this->router->generate('wi_front_newsletter_receiver', [], UrlGeneratorInterface::ABSOLUTE_URL).'" method="POST">
                <input type="hidden" name="group" value="'.$id.'">
                <input type="hidden" name="email_repeat" value="">
                '.$name.'<div class="wi-newsletter-field">
                    <label for="email">Adres e-mail:</label>
                    <input type="email" name="email" required>
                </div>
                <div class="wi-newsletter-field">
                    <input type="submit" value="Zapisz">
                </div>
            </form>
        </div>';

        return $code;
    }
}
