<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_newsletter_mainsite_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.recipient.recipientNew')) ?>

<?php $view['slots']->start('stylesheets') ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/chosen/chosen.min.css') ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css') ?>"  rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/newsletter.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"  rel="stylesheet" type="text/css" />
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_newsletter_mainsite_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.newsletter.newsletter'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_newsletter_recipients_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.recipient.recipientList'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_newsletter_recipients_new'); ?>"><?php echo $view['translator']->trans('breadcrumbs.recipient.recipientNew'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <i class="icon-mail"></i><?php echo $view['translator']->trans('recipient.listTitle'); ?> - <?php echo $view['translator']->trans('recipient.subTitleNew'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('recipient.new.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>

<?php echo $view['form']->start($form, array('multipart' => true, 'attr' => array( 'id' => 'wi_admin_newsletterbundle_recipients' ))); ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title">
                <i class="icon-doc-add"></i> <span><?php echo $view['translator']->trans('recipient.new.boxTitle'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('recipient.new.email'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('recipient.new.emailDesc'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['email']); ?>
                            </div>
                        <?php echo ($view['form']->errors($form['email']) ? $view['form']->widget($form['email'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['email'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('recipient.new.name'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('recipient.new.nameDesc'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['name']); ?>
                            </div>
                        <?php echo ($view['form']->errors($form['name']) ? $view['form']->widget($form['name'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['name'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('recipient.new.lang'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('recipient.new.langDesc'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-3 columns end">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['lang']); ?>
                            </div>
                        <?php echo ($view['form']->errors($form['lang']) ? $view['form']->widget($form['lang'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['lang'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('recipient.new.consent'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('recipient.new.consentDesc'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-3 columns end">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['consent']); ?>
                            </div>
                        <?php echo ($view['form']->errors($form['consent']) ? $view['form']->widget($form['consent'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['consent'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                </div>
                <div class="large-10 columns">
                    <div class="news-add-form">
                        <div class="formAlert">
                            <?php echo $view['form']->errors($form['status']); ?>
                        </div>
                        <div class="hiddenBlock">
                            <?php echo ($view['form']->errors($form['status']) ? $view['form']->widget($form['status'], ['required' => false], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['status'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="large-2 columns">
                </div>
                <div class="large-10 columns">
                    <div class="news-add-form">
                        <?php echo $view['form']->widget($form); ?>
                        <button class="button" type="submit" value="<?php echo $view['translator']->trans('Form.create'); ?>">
                            <i class="icon-plus"></i> <?php echo $view['translator']->trans('Form.create'); ?>
                        </button>
                        <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_newsletter_recipient_group_show', ['id' => $recipientGroup->getId()]); ?>">
                            <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.back'); ?>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php echo $view['form']->end($form); ?>

<?php $view['slots']->stop() ?>


<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/chosen/chosen.jquery.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/jquery.tooltipster.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/newsletter.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
