<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_newsletter_mainsite_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.recipient.recipientList')) ?>

<?php $view['slots']->start('stylesheets') ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css') ?>"  rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/newsletter.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"  rel="stylesheet" type="text/css" />
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_newsletter_mainsite_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.newsletter.newsletter'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_newsletter_recipients_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.recipient.recipientList'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <i class="icon-mail"></i><?php echo $view['translator']->trans('recipient.listTitle'); ?> - <?php echo $view['translator']->trans('recipient.subTitle'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('recipient.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>

<!--RECIPIENTS LIST-->
<div class="box">
    <div class="box-header bg-transparent">
        <!-- tools box -->
        <div class="pull-right box-tools">
            <span class="box-btn" data-toggle="configNews-dropdown5">
                    <i class="icon-cog-5"></i>
            </span>
            <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configNews-dropdown5" data-dropdown data-close-on-click="true">
                <ul class="no-bullet">
                    <?php if ($view['security']->isGranted('ROLE_NEWSLETTER_EDIT')): ?>
                        <li>
                            <a href="<?php echo $view['router']->path('wi_admin_newsletter_recipients_new') ?>"  title="<?php echo $view['translator']->trans('recipient.add'); ?>">
                                <span><i class="icon-folder-add"></i><?php echo $view['translator']->trans('recipient.add'); ?></span>
                            </a>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
        <h3 class="box-title" data-widget="collapse"><i class="icon-help-circled"></i>
            <span><?php echo $view['translator']->trans('recipient.list'); ?></span>
        </h3>
    </div>
    <!-- /.box-body -->
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="large-2 columns">
                <div class="reveal" id="importModal1" data-reveal>
                        <div class="box">
                            <?php echo $view['form']->start($form, ['attr' => ['id' => 'wi_admin_newsletterbundle_recipients_csv']]); ?>
                                <label for="wi_admin_newsletterbundle_recipients_csv" >
                                <?php echo $view['form']->widget($form['file']); ?>
                                    <input type="submit">
                                </label>
                            <?php echo $view['form']->end($form); ?>
                        </div>
                    <button class="close-button" data-close aria-label="Close modal" type="button">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <button class="button" type="button" data-open="importModal1" value="<?php echo $view['translator']->trans('recipient.import'); ?>">
                    <i class="icon-plus"></i><?php echo $view['translator']->trans('recipient.import'); ?>
                </button>
            </div>
            <div class="large-10 columns"></div>
            <div class="columns end tableResp">
                <table id="recipientsList" class="display" style="width:100%">
                    <thead>
                    <tr>
                        <th><?php echo $view['translator']->trans('recipient.email'); ?></th>
                        <th><?php echo $view['translator']->trans('recipient.name'); ?></th>
                        <th><?php echo $view['translator']->trans('recipient.lang'); ?></th>
                        <th><?php echo $view['translator']->trans('recipient.consent'); ?></th>
                        <th><?php echo $view['translator']->trans('recipient.status'); ?></th>
                    </tr>
                    </thead>
                        <tbody>
                            <?php foreach ($recipients as $recipient) { ?>
                                <tr>
                                    <td><?php echo $recipient->getEmail(); ?>
                                        <div class="buttonItemsBox recipientsBox">
                                           <div class="buttonsItems recipientsBox">
                                               <?php if ($view['security']->isGranted('ROLE_NEWSLETTER_EDIT')) { ?>
                                                        <a href="<?php echo $view['router']->path('wi_admin_newsletter_recipients_edit', ['id' => $recipient->getId()]) ?>" class=""><i class="icon-edit-1"></i><?php echo $view['translator']->trans('Table.editButton') ?></a>
                                                    <?php } ?>
                                               <?php if ($view['security']->isGranted('ROLE_NEWSLETTER_EDIT')) { ?>
                                                   <a href="<?php echo $view['router']->path('wi_admin_newsletter_recipients_delete', ['id' => $recipient->getId()]) ?>" class=""><i class="icon-cancel-circled-outline"></i><?php echo $view['translator']->trans('Table.deleteButton') ?></a>
                                               <?php } ?>
                                           </div>
                                        </div>
                                    </td>
                                    <td><?php echo $recipient->getName(); ?></td>
                                    <td><?php echo $recipient->getLang(); ?></td>
                                    <td><?php echo $recipient->getConsent(); ?></td>
                                    <td><?php echo $recipient->getStatus(); ?></td>
                                </tr>
                            <?php } ?>
                        </tbody>
                </table>
            </div>
        </div>
        <div class="row">
            <div class="large-2 columns">
                <button class="button" type="button" data-open="importModal1" value="<?php echo $view['translator']->trans('recipient.import'); ?>">
                    <i class="icon-plus"></i><?php echo $view['translator']->trans('recipient.import'); ?>
                </button>
            </div>
            <div class="large-10 columns">
                <div class="news-add-form">
                    <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_newsletter_mainsite_index'); ?>">
                        <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.back'); ?>
                    </a>
                </div>
                <div class="medium-6 columns paginationBox pagingRecipients">
                <?php echo $view->render('KnpPaginatorBundle/Pagination/per_page_logs.html.php', [
                    'knp_pagination' => $recipients,
                ]); ?>

                <?php echo $view['knp_pagination']->render($recipients); ?>
            </div>
            </div>
        </div>
    </div>
</div>

<script>
        var language = '<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/i18n/'.$view['request']->getLocale().'.json'); ?>';
    </script>

<?php $view['slots']->stop() ?>


<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/newsletter.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>

