<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_newsletter_mainsite_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.recipient.recipientList')) ?>

<?php $view['slots']->start('stylesheets') ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css') ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/newsletter.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
<li><a href="<?php echo $view['router']->path('wi_admin_newsletter_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.newsletter.newsletter'); ?></a></li>
<li><a href="<?php echo $view['router']->path('wi_admin_newsletter_recipients_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.recipient.recipientList'); ?></a></li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
<i class="icon-mail"></i> Recipient group - Show
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
Recipient group show.
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
<div class="row">
    <div class="large-12 columns">
        <div class="box">
            <div class="box-header bg-transparent">
                <div class="pull-right box-tools">
                    <?php if ($view['security']->isGranted('ROLE_NEWSLETTER_EDIT') && $recipientGroup->getId() != 1): ?>
                        <span class="box-btn" data-toggle="dropdown-1">
                            <i class="icon-cog-5"></i>
                        </span>
                        <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="dropdown-1" data-dropdown data-close-on-click="true">
                            <ul class="no-bullet">
                                <li>
                                    <a href="<?php echo $view['router']->path('wi_admin_newsletter_recipients_new', ['rid' => $recipientGroup->getId()]); ?>"  title="<?php echo $view['translator']->trans('recipient.add'); ?>">
                                        <span><i class="icon-folder-add"></i><?php echo $view['translator']->trans('recipient.add'); ?></span>
                                    </a>
                                </li>
                                <li>
                                    <a href="<?php echo $view['router']->path('wi_admin_newsletter_recipient_group_delete', ['id' => $recipientGroup->getId()]); ?>" title="Delete recipient group">
                                        <span><i class="icon-trash"></i>Delete recipient group</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    <?php endif; ?>
                    <div class="pull-right box-tools">
                        <span>
                            <i class="icon-up-open collapseExpand" data-widget="collapse"></i>
                        </span>
                    </div>
                </div>
                <h3 class="box-title" data-widget="collapse"><i class="icon-help-circled"></i>
                    <span>Show details - <?php echo $recipientGroup->getName(); ?></span>
                </h3>
            </div>
            <div class="box-body" style="display: block;">
                 <div class="row">
                    <div class="large-2 columns">
                        <p><strong>Name:</strong></p>
                    </div>
                    <div class="large-10 columns">
                        <p><?php echo $recipientGroup->getName(); ?></p>
                    </div>
                </div>
                 <div class="row">
                    <div class="large-2 columns">
                        <p><strong>Number of recipients:</strong></p>
                    </div>
                    <div class="large-10 columns">
                        <p><?php echo $recipientGroup->getRecipientsCount(); ?></p>
                    </div>
                </div>
                <hr>
                 <div class="row">
                    <div class="large-12 columns">
                        <p><strong>Recipient list:</strong></p>
                    </div>
                </div>
                <div class="row">
                    <div class="columns end tableResp">
                        <table id="recipientsList" class="display" style="width:100%">
                            <thead>
                                <tr>
                                    <?php if ($recipientGroup->getId() != 1): ?>
                                        <th><input type="checkbox" id="select_all"></th>
                                    <?php endif ?>
                                    <th><?php echo $view['translator']->trans('recipient.email'); ?></th>
                                    <th><?php echo $view['translator']->trans('recipient.name'); ?></th>
                                    <th><?php echo $view['translator']->trans('recipient.consent'); ?></th>
                                    <th><?php echo $view['translator']->trans('recipient.status'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php foreach ($recipients as $recipient): ?>
                                <tr>
                                    <?php if ($recipientGroup->getId() != 1): ?>
                                        <td class="input-row">
                                            <input type="checkbox" name="Recipient[id][]" class="input-checkbox" value="<?php echo $recipient->getId(); ?>">
                                        </td>
                                    <?php endif ?>
                                    <td><?php echo $recipient->getEmail(); ?>
                                        <div class="buttonItemsBox recipientsBox">
                                           <div class="buttonsItems recipientsBox">
                                               <?php if ($view['security']->isGranted('ROLE_NEWSLETTER_EDIT') && $recipientGroup->getId() != 1): ?>
                                                    <a href="<?php echo $view['router']->path('wi_admin_newsletter_recipients_edit', ['id' => $recipient->getId()]) ?>" class=""><i class="icon-edit-1"></i><?php echo $view['translator']->trans('Table.editButton') ?></a>
                                                    <a href="<?php echo $view['router']->path('wi_admin_newsletter_recipients_delete', ['id' => $recipient->getId()]) ?>" class=""><i class="icon-cancel-circled-outline"></i><?php echo $view['translator']->trans('Table.deleteButton') ?></a>
                                                <?php endif; ?>
                                           </div>
                                        </div>
                                    </td>
                                    <td><?php echo $recipient->getName(); ?></td>
                                    <td>
                                    <?php if ($recipient->getConsent()): ?>
                                        <span class="consent ok">
                                            <i class="icon-ok-circled"></i>
                                        </span>
                                    <?php else: ?>
                                        <span class="consent fail">
                                            <i class="icon-block"></i>
                                        </span>
                                    <?php endif; ?>
                                    </td>
                                    <td><?php echo $recipient->getStatus(); ?></td>
                                </tr>
                            <?php endforeach ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="row">
                    <div class="large-2 columns">
                        <?php if ($recipientGroup->getId() != 1): ?>
                            <button class="button" type="button" data-open="importModal1" value="<?php echo $view['translator']->trans('recipient.import'); ?>">
                                <i class="icon-plus"></i><?php echo $view['translator']->trans('recipient.import'); ?>
                            </button>
                        <?php endif ?>
                    </div>
                    <div class="large-2 columns">
                        <?php if ($recipientGroup->getId() != 1): ?>
                            <select name="action" id="select_action">
                                <option value="#">- select option -</option>
                                <option value="consent-0">Lack of consent</option>
                                <option value="consent-1">Consent approved</option>
                                <option value="delete">Delete</option>
                            </select>
                        <?php endif ?>
                    </div>
                    <div class="large-8 columns">
                        <div class="news-add-form">
                            <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_newsletter_index', ['_fragment' => 'recipient-groups']); ?>">
                                <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.back'); ?>
                            </a>
                            <div class="reveal" id="importModal1" data-reveal>
                                <div class="box">
                                    <?php echo $view['form']->start($form, ['attr' => ['id' => 'wi_admin_newsletterbundle_recipients_csv']]); ?>
                                        <label for="wi_admin_newsletterbundle_recipients_csv" >
                                        <?php echo $view['form']->widget($form['file']); ?>
                                            <input type="submit">
                                        </label>
                                    <?php echo $view['form']->end($form); ?>
                                </div>
                                <button class="close-button" data-close aria-label="Close modal" type="button">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                        </div>
                        <div class="medium-6 columns paginationBox pagingRecipients">
                        <?php echo $view->render('KnpPaginatorBundle/Pagination/per_page_logs.html.php', [
                            'knp_pagination' => $recipients,
                        ]); ?>

                        <?php echo $view['knp_pagination']->render($recipients); ?>
                    </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="box collapsed-box">
    <div class="box-header bg-transparent">
        <div class="pull-right box-tools">
            <span><i class="icon-up-open" data-widget="collapse"></i></span>
        </div>
        <h3 class="box-title" data-widget="collapse"><i class="icon-code"></i><span><?php echo $view['translator']->trans('recipientGroup.embedSingUpForm'); ?></span></h3>
    </div>
    <div class="box-body " style="display: none;">
        <p><?php echo $view['translator']->trans('recipientGroup.addNameField'); ?></p>
        <div>
            <input type="checkbox" id="addName" class="switch-input" value="1">
            <label class="switch-paddle" for="addName">
                <span class="show-for-sr"></span>
                <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
            </label>
        </div>
        <textarea id="code" rows="15"></textarea>
    </div>
</div>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
<script>
$('#addName').change(function (e) {
    var val = $(this)[0].checked ? 1 : 0;

    $.ajax({
        url: Routing.generate('wi_admin_newsletter_recipient_group_form_code', { 'id': <?php echo $recipientGroup->getId(); ?> }),
        method: 'POST',
        data: {
            'add_name': val,
        },
        dataType: 'JSON',
        success: function (response) {
            $('#code').val(response.code);
        }
    });
}).change();

</script>
<script>
    var language = '<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/i18n/'.$view['request']->getLocale().'.json'); ?>';
</script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js') ?>" type="text/javascript"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/newsletter.js?v=1') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
