<div class="row">
    <div class="large-12 columns">
        <div class="box">
            <div class="box-header bg-transparent">
                <div class="pull-right box-tools">
                    <span class="box-btn" data-toggle="dropdown-senders-1">
                        <i class="icon-cog-5"></i>
                    </span>
                    <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="dropdown-senders-1" data-dropdown data-close-on-click="true">
                        <ul class="no-bullet">
                            <?php if ($view['security']->isGranted('ROLE_NEWSLETTER_EDIT')): ?>
                                <li>
                                    <a href="<?php echo $view['router']->path('wi_admin_newsletter_senders_new'); ?>"  title="<?php echo $view['translator']->trans('blockList.addNewBlock'); ?>">
                                        <span><i class="icon-folder-add"></i>Create new sender</span>
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                    <div class="pull-right box-tools">
                        <span>
                            <i class="icon-up-open collapseExpand" data-widget="collapse"></i>
                        </span>
                    </div>
                </div>
                <h3 class="box-title" data-widget="collapse"><i class="icon-help-circled"></i>
                    <span>Senders list</span>
                </h3>
            </div>
            <div class="box-body" style="display: block;">
                <div class="row">
                    <table>
                        <thead>
                            <tr>
                                <th>Id</th>
                                <th>E-mail</th>
                                <th>Name</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($senders as $sender): ?>
                            <tr>
                                <td><?php echo $sender->getId(); ?></td>
                                <td>
                                    <a href="<?php echo $view['router']->path('wi_admin_newsletter_senders_show', ['id' => $sender->getId()]); ?>">
                                        <?php echo $sender->getEmail(); ?>
                                    </a>
                                </td>
                                <td><?php echo $sender->getName(); ?></td>
                            </tr>
                        <?php endforeach ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
