<div class="row">
    <div class="large-12 columns">
        <div class="box">
            <div class="box-header bg-transparent">
                <div class="pull-right box-tools">
                    <span class="box-btn" data-toggle="dropdown-recipient-groups-1">
                        <i class="icon-cog-5"></i>
                    </span>
                    <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="dropdown-recipient-groups-1" data-dropdown data-close-on-click="true">
                        <ul class="no-bullet">
                            <?php if ($view['security']->isGranted('ROLE_NEWSLETTER_EDIT')): ?>
                                <li>
                                    <a href="<?php echo $view['router']->path('wi_admin_newsletter_recipient_group_new'); ?>"  title="<?php echo $view['translator']->trans('blockList.addNewBlock'); ?>">
                                        <span><i class="icon-folder-add"></i>Add new recipient group</span>
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                    <div class="pull-right box-tools">
                        <span>
                            <i class="icon-up-open collapseExpand" data-widget="collapse"></i>
                        </span>
                    </div>
                </div>
                <h3 class="box-title" data-widget="collapse"><i class="icon-help-circled"></i>
                    <span>Recipient groups</span>
                </h3>
            </div>
            <div class="box-body" style="display: block;">
                <div class="row">
                    <table>
                        <thead>
                            <tr>
                                <th>Id</th>
                                <th>Name</th>
                                <th>Recipients</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($recipientGroups as $recipientGroup): ?>
                            <tr>
                                <td><?php echo $recipientGroup->getId(); ?></td>
                                <td>
                                    <a href="<?php echo $view['router']->path('wi_admin_newsletter_recipient_group_show', ['id' => $recipientGroup->getId()]); ?>">
                                        <?php echo $recipientGroup->getName(); ?>
                                    </a>
                                </td>
                                <td><?php echo $recipientGroup->getRecipientsCount(); ?></td>
                            </tr>
                        <?php endforeach ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
