<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_newsletter_mainsite_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.newsletter.newsletter')); ?>

<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css'); ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css'); ?>" >
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/chosen/chosen.min.css'); ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/date-dropdown/jquery.datetimepicker.css'); ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/newsletter.css'); ?><?php echo $view['config']->getParameter('vStyle'); ?>" >
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li><a href="<?php echo $view['router']->path('wi_admin_newsletter_mainsite_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.newsletter.newsletter'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
<i class="icon-mail"></i><?php echo $view['translator']->trans('newsletter.listTitle'); ?> - <?php echo $view['translator']->trans('newsletter.listSubTitle'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleDesc'); ?>
<?php echo $view['translator']->trans('newsletter.desc'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
<?php $checkboxes = str_split($daysOfWeek->getParamValue()); ?>
<div class="row">
    <div class="large-5 columns">
        <div class="box">
            <div class="box-header bg-transparent">
                <div class="pull-right box-tools">
                    <span>
                        <i class="icon-up-open collapseExpand" data-widget="collapse"></i>
                    </span>
                </div>
                <h3 class="box-title" data-widget="collapse"><i class="icon-help-circled"></i>
                    <span><?php echo $view['translator']->trans('newsletter.blocks.statusbar'); ?> - <?php echo $view['translator']->trans('newsletter.blockContent.statusbar.system'); ?></span>
                    <?php if ($enableNewsletter->getParamValue() == 0): ?>
                        <span class="statusIcon"><i class="icon-cancel statusB">OFF</i></span>
                    <?php else: ?>
                        <span class="statusIcon"><i class="icon-check statusB">ON</i></span>
                    <?php endif; ?>
                </h3>
            </div>
            <div class="box-body" style="display: block">
                <table id="statusBar" style="width: 100%">
                    <tbody>
                        <tr>
                            <td><strong><?php echo $view['translator']->trans('newsletter.blockContent.statusbar.system'); ?>:</strong></td>
                            <td style="color: red;"><?php echo (isset($infoTab[7]) ? $infoTab[7] : ''); ?></td>
                        </tr>
                        <tr>
                            <td><strong><?php echo $view['translator']->trans('newsletter.blockContent.statusbar.aCampaining'); ?>:</strong></td>
                            <td><?php echo $infoTab[6]; ?></td>
                        </tr>
                        <tr>
                            <td style="padding-left: 35px !important;"><strong><?php echo $view['translator']->trans('newsletter.blockContent.statusbar.range'); ?>:</strong></td>
                            <td><?php if($infoTab[1] && $infoTab[2]) {echo $infoTab[1]->format('Y-m-d'); ?> - <?php echo $infoTab[2]->format('Y-m-d');} ?></td>
                        </tr>
                        <tr>
                            <td style="padding-left: 35px !important;"><strong><?php echo $view['translator']->trans('newsletter.blockContent.statusbar.contents'); ?>:</strong></td>
                            <td><?php echo $infoTab[3]; ?></td>
                        </tr>
                        <tr>
                            <td style="padding-left: 35px !important;"><strong><?php echo $view['translator']->trans('newsletter.blockContent.statusbar.langs'); ?>:</strong></td>
                            <td><?php echo $langs['messages']; ?>
                            </td>
                        </tr>
                        <tr>
                            <td><strong><?php echo $view['translator']->trans('newsletter.blockContent.statusbar.recipients'); ?>:</strong></td>
                            <td><?php echo count($recipients); ?>    <a href="<?php echo $view['router']->path('wi_admin_newsletter_recipients_index'); ?>"  title="<?php echo $view['translator']->trans('newsletter.blockContent.statusbar.manage'); ?>">
                                <br class="show-for-small-only"><span class="button tiny mRecipientsButton"><?php echo $view['translator']->trans('newsletter.blockContent.statusbar.manage'); ?></span></td>
                        </tr>
                        <tr>
                            <td style="padding-left: 35px !important;"><strong><?php echo $view['translator']->trans('newsletter.blockContent.statusbar.messagesS'); ?>:</strong></td>
                            <td><?php echo $sendedMessages->count(); ?></td>
                        </tr>
                        <tr>
                            <td style="padding-left: 35px !important;"><strong><?php echo $view['translator']->trans('newsletter.blockContent.statusbar.messagesA'); ?>:</strong></td>
                            <td><?php echo $awaitingMessages; ?></td>
                        </tr>
                        <tr>
                            <td><strong><?php echo $view['translator']->trans('newsletter.blockContent.statusbar.sendersC'); ?>:</strong></td>
                            <td><?php echo $infoTab[5]; ?></td>
                        </tr>
                        <tr>
                            <td><strong><?php echo $view['translator']->trans('newsletter.blockContent.statusbar.sendersL'); ?>:</strong></td>
                            <td><?php echo $langs['senders']; ?></td>
                        </tr>
                    </tbody>
                </table>
                <div class="row">
                    <div class="medium-6 columns">
                        <?php if ($view['security']->isGranted('ROLE_NEWSLETTER_EDIT')): ?>
                            <a href="<?php echo $view['router']->path('wi_admin_newsletter_mainsite_manual_start'); ?>"><span class="label button alert">Manually start the cycle</span></a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="large-7 columns">
        <!--STATS-->
        <div class="box">
            <div class="box-header bg-transparent">
                <div class="pull-right box-tools">
                    <span><i class="icon-up-open collapseExpand" data-widget="collapse"></i></span>
                </div>
                <h3 class="box-title" data-widget="collapse"><i class="icon-help-circled"></i>
                    <span><?php echo $view['translator']->trans('newsletter.blocks.stats'); ?></span>
                </h3>
            </div>
            <div class="box-body statistic-charts" style="display: block">
                <ul class="tabs statistic-tabs" data-tabs id="statistic-tabs">
                    <li class="tabs-title"><a data-tabs-target="campaign" href="#campaign">Campaign</a></li>
                    <li class="tabs-title"><a data-tabs-target="monthly" href="#monthly">Monthly</a></li>
                    <li class="tabs-title is-active"><a data-tabs-target="daily" href="#daily" aria-selected="true">Daily</a></li>
                </ul>
                <div class="tabs-content statistic-tabs-content" data-tabs-content="statistic-tabs">
                    <div class="tabs-panel" id="campaign">
                        <div id="campaign-chart"></div>
                    </div>
                    <div class="tabs-panel" id="monthly">
                        <div id="monthly-chart"></div>
                        <div class="nav">
                            <div class="nav-link">
                                <a id="monthly_prev">Prev</a>
                            </div>
                            <span id="curr_month"></span>
                            <div class="nav-link">
                                <a id="monthly_next">Next</a>
                            </div>
                        </div>
                    </div>
                    <div class="tabs-panel is-active" id="daily">
                        <div id="daily-chart"></div>
                        <div class="nav">
                            <div class="nav-link">
                                <a id="daily_prev">Prev</a>
                            </div>
                            <span id="curr_day"></span>
                            <div class="nav-link">
                                <a id="daily_next">Next</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="box configS">
    <h3><span><?php echo $view['translator']->trans('newsletter.blockContent.config.settings'); ?></span></h3>
    <div class="row">
        <div class="large-6 columns">
            <!--CONFIG-->
            <div class="box collapsed-box">
                <div class="box-header bg-transparent">
                    <div class="pull-right box-tools">
                        <span>
                            <i class="icon-up-open collapseExpand" data-widget="collapse"></i>
                        </span>
                    </div>
                    <h3 class="box-title" data-widget="collapse"><i class="icon-help-circled"></i>
                        <span><?php echo $view['translator']->trans('newsletter.blocks.config'); ?></span>
                    </h3>
                </div>
                <!-- /.box-body -->
                <div class="box-body " style="display: none;">
                    <div class="row">
                        <div class="medium-6 columns ">
                            <?php if ($view['security']->isGranted('ROLE_NEWSLETTER_EDIT')): ?>

                            <?php endif; ?>
                        </div>
                        <div class="columns end tableResp">
                            <table id="configInfo" class="tableResp" style="width:100%">
                                <thead>
                                    <tr>
                                        <th><?php echo $view['translator']->trans('newsletter.blockContent.config.paramName'); ?></th>
                                        <th><?php echo $view['translator']->trans('newsletter.blockContent.config.paramValue'); ?></th>
                                        <th><?php echo $view['translator']->trans('newsletter.blockContent.config.aidValue'); ?></th>
                                        <th>&nbsp;</th>
                                    </tr>
                                </thead>
                                <tbody>
                                        <tr>
                                            <td id="paramName_<?php echo $enableNewsletter->getId(); ?>"><?php echo $enableNewsletter->getParamName(); ?></td>
                                            <td>
                                                <div class="switch tiny">
                                                    <input type="checkbox" class="inputConfig switch-input switchConfig" id="paramValue_<?php echo $enableNewsletter->getId(); ?>" value="<?php echo $enableNewsletter->getParamValue(); ?>" disabled>
                                                    <label class="switch-paddle labelSwitch" for="paramValue_<?php echo $enableNewsletter->getId(); ?>">
                                                        <span class="show-for-sr">Enable newsletter</span>
                                                        <span class="switch-active" aria-hidden="true">ON</span>
                                                        <span class="switch-inactive" aria-hidden="true">OFF</span>
                                                    </label>
                                                </div>
                                            </td>
                                            <td><input type="text" class="inputConfig aidValue" id="aidValue_<?php echo $enableNewsletter->getId(); ?>" value="<?php echo $enableNewsletter->getAidValue(); ?>" disabled></td>
                                            <td>
                                                <div class="buttonItemsBox config">
                                                    <div class="buttonsItems config">
                                                        <span><i id="<?php echo $enableNewsletter->getId(); ?>" class="icon-pencil"></i></span>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td id="paramName_<?php echo $quantityToSent->getId(); ?>"><?php echo $quantityToSent->getParamName(); ?></td>
                                            <td><input type="number" class="inputConfig quantity_to_sent" id="paramValue_<?php echo $quantityToSent->getId(); ?>" value="<?php echo $quantityToSent->getParamValue(); ?>" disabled></td>
                                            <td><input type="text" class="inputConfig aidValue" id="aidValue_<?php echo $quantityToSent->getId(); ?>" value="<?php echo $quantityToSent->getAidValue(); ?>" disabled></td>
                                            <td>
                                                <div class="buttonItemsBox config">
                                                    <div class="buttonsItems config">
                                                        <span><i id="<?php echo $quantityToSent->getId(); ?>" class="icon-pencil"></i></span>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td id="paramName_<?php echo $currentCampaign->getId(); ?>"><?php echo $currentCampaign->getParamName(); ?></td>
                                            <td>
                                                <select id="paramValue_<?php echo $currentCampaign->getId(); ?>" class="chosen-select selectCampaignParam" disabled="disabled">
                                                    <?php foreach ($campaigns as $singleCampaign) { ?>
                                                    <option value="<?php echo $singleCampaign->getId(); ?>" <?php if($singleCampaign->getId()==$currentCampaign->getParamValue()) {echo 'selected';} ?>><?php echo $singleCampaign->getName(); ?></option>
                                                    <?php } ?>
                                                </select>
                                            </td>
                                            <td><input type="text" class="inputConfig aidValue" id="aidValue_<?php echo $currentCampaign->getId(); ?>" value="<?php echo $currentCampaign->getAidValue(); ?>" disabled></td>
                                            <td>
                                                <div class="buttonItemsBox config">
                                                    <div class="buttonsItems config">
                                                        <span><i id="<?php echo $currentCampaign->getId(); ?>" class="icon-pencil"></i></span>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td id="paramName_<?php echo $dateStart->getId(); ?>"><?php echo $dateStart->getParamName(); ?></td>
                                            <td><input type="text" class="inputConfig date_start" id="paramValue_<?php echo $dateStart->getId(); ?>" value="<?php echo $dateStart->getParamValue(); ?>" disabled></td>
                                            <td><input type="text" class="inputConfig aidValue" id="aidValue_<?php echo $dateStart->getId(); ?>" value="<?php echo $dateStart->getAidValue(); ?>" disabled></td>
                                            <td>
                                                <div class="buttonItemsBox config">
                                                    <div class="buttonsItems config">
                                                        <span><i id="<?php echo $dateStart->getId(); ?>" class="icon-pencil"></i></span>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td id="paramName_<?php echo $dateEnd->getId(); ?>"><?php echo $dateEnd->getParamName(); ?></td>
                                            <td><input type="text" class="inputConfig date_end" id="paramValue_<?php echo $dateEnd->getId(); ?>" value="<?php echo $dateEnd->getParamValue(); ?>" disabled></td>
                                            <td><input type="text" class="inputConfig aidValue" id="aidValue_<?php echo $dateEnd->getId(); ?>" value="<?php echo $dateEnd->getAidValue(); ?>" disabled></td>
                                            <td>
                                                <div class="buttonItemsBox config">
                                                    <div class="buttonsItems config">
                                                        <span><i id="<?php echo $dateEnd->getId(); ?>" class="icon-pencil"></i></span>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td id="paramName_<?php echo $randomizeSenders->getId(); ?>"><?php echo $randomizeSenders->getParamName(); ?></td>
                                            <td>
                                                <div class="switch tiny">
                                                    <input type="checkbox" class="inputConfig  switch-input switchConfig" id="paramValue_<?php echo $randomizeSenders->getId(); ?>" value="<?php echo $randomizeSenders->getParamValue(); ?>" disabled>
                                                    <label class="switch-paddle labelSwitch" for="paramValue_<?php echo $randomizeSenders->getId(); ?>">
                                                        <span class="show-for-sr">Enable newsletter</span>
                                                        <span class="switch-active" aria-hidden="true">ON</span>
                                                        <span class="switch-inactive" aria-hidden="true">OFF</span>
                                                    </label>
                                                </div>
                                            </td>
                                            <td><input type="text" class="inputConfig aidValue" id="aidValue_<?php echo $randomizeSenders->getId(); ?>" value="<?php echo $randomizeSenders->getAidValue(); ?>" disabled></td>
                                            <td>
                                                <div class="buttonItemsBox config">
                                                    <div class="buttonsItems config">
                                                        <span><i id="<?php echo $randomizeSenders->getId(); ?>" class="icon-pencil"></i></span>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td id="paramName_<?php echo $randomizeRecipients->getId(); ?>"><?php echo $randomizeRecipients->getParamName(); ?></td>
                                            <td>
                                                <div class="switch tiny">
                                                    <input type="checkbox" class="inputConfig switch-input switchConfig" id="paramValue_<?php echo $randomizeRecipients->getId(); ?>" value="<?php echo $randomizeRecipients->getParamValue(); ?>" disabled>
                                                    <label class="switch-paddle labelSwitch" for="paramValue_<?php echo $randomizeRecipients->getId(); ?>">
                                                        <span class="show-for-sr">Enable newsletter</span>
                                                        <span class="switch-active" aria-hidden="true">ON</span>
                                                        <span class="switch-inactive" aria-hidden="true">OFF</span>
                                                    </label>
                                                </div>
                                            </td>
                                            <td><input type="text" class="inputConfig aidValue" id="aidValue_<?php echo $randomizeRecipients->getId(); ?>" value="<?php echo $randomizeRecipients->getAidValue(); ?>" disabled></td>
                                            <td>
                                                <div class="buttonItemsBox config">
                                                    <div class="buttonsItems config">
                                                        <span><i id="<?php echo $randomizeRecipients->getId(); ?>" class="icon-pencil"></i></span>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td id="paramName_<?php echo $randomizeMessages->getId(); ?>"><?php echo $randomizeMessages->getParamName(); ?></td>
                                            <td>
                                                <div class="switch tiny">
                                                    <input type="checkbox" class="inputConfig switch-input switchConfig" id="paramValue_<?php echo $randomizeMessages->getId(); ?>" value="<?php echo $randomizeMessages->getParamValue(); ?>" disabled>
                                                    <label class="switch-paddle labelSwitch" for="paramValue_<?php echo $randomizeMessages->getId(); ?>">
                                                        <span class="show-for-sr">Enable newsletter</span>
                                                        <span class="switch-active" aria-hidden="true">ON</span>
                                                        <span class="switch-inactive" aria-hidden="true">OFF</span>
                                                    </label>
                                                </div>
                                            </td>
                                            <td><input type="text" class="inputConfig aidValue" id="aidValue_<?php echo $randomizeMessages->getId(); ?>" value="<?php echo $randomizeMessages->getAidValue(); ?>" disabled></td>
                                            <td>
                                                <div class="buttonItemsBox config">
                                                    <div class="buttonsItems config">
                                                        <span><i id="<?php echo $randomizeMessages->getId(); ?>" class="icon-pencil"></i></span>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td id="paramName_<?php echo $bcc->getId(); ?>"><?php echo $bcc->getParamName(); ?></td>
                                            <td><input type="text" class="inputConfig" id="paramValue_<?php echo $bcc->getId(); ?>" name="<?php echo $bcc->getParamName(); ?>" value="<?php echo $bcc->getParamValue(); ?>" disabled></td>
                                            <td><input type="text" class="inputConfig aidValue" id="aidValue_<?php echo $bcc->getId(); ?>" value="<?php echo $bcc->getAidValue(); ?>" disabled></td>
                                            <td>
                                                <div class="buttonItemsBox config">
                                                    <div class="buttonsItems config">
                                                        <span><i id="<?php echo $bcc->getId(); ?>" class="icon-pencil"></i></span>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td id="paramName_<?php echo $daysOfWeek->getId(); ?>"><?php echo $daysOfWeek->getParamName(); ?></td>
                                            <td>
                                                <label class="labelDaysOfWeek"><input type="checkbox" class="inputConfig checkboxDaysOfWeek" id="paramValue_<?php echo $daysOfWeek->getId(); ?>_1" value="1" disabled <?php if(in_array(1,$checkboxes)) {echo 'checked';} ?>>Pn</label>
                                                <label class="labelDaysOfWeek"><input type="checkbox" class="inputConfig checkboxDaysOfWeek" id="paramValue_<?php echo $daysOfWeek->getId(); ?>_2" value="2" disabled <?php if(in_array(2,$checkboxes)) {echo 'checked';} ?>>Wt</label>
                                                <label class="labelDaysOfWeek"><input type="checkbox" class="inputConfig checkboxDaysOfWeek" id="paramValue_<?php echo $daysOfWeek->getId(); ?>_3" value="3" disabled <?php if(in_array(3,$checkboxes)) {echo 'checked';} ?>>Sr</label>
                                                <label class="labelDaysOfWeek"><input type="checkbox" class="inputConfig checkboxDaysOfWeek" id="paramValue_<?php echo $daysOfWeek->getId(); ?>_4" value="4" disabled <?php if(in_array(4,$checkboxes)) {echo 'checked';} ?>>Cz</label>
                                                <label class="labelDaysOfWeek"><input type="checkbox" class="inputConfig checkboxDaysOfWeek" id="paramValue_<?php echo $daysOfWeek->getId(); ?>_5" value="5" disabled <?php if(in_array(5,$checkboxes)) {echo 'checked';} ?>>Pt</label>
                                                <label class="labelDaysOfWeek"><input type="checkbox" class="inputConfig checkboxDaysOfWeek" id="paramValue_<?php echo $daysOfWeek->getId(); ?>_6" value="6" disabled <?php if(in_array(6,$checkboxes)) {echo 'checked';} ?>>So</label>
                                                <label class="labelDaysOfWeek"><input type="checkbox" class="inputConfig checkboxDaysOfWeek" id="paramValue_<?php echo $daysOfWeek->getId(); ?>_7" value="7" disabled <?php if(in_array(7,$checkboxes)) {echo 'checked';} ?>>Nd</label>
                                            </td>
                                            <td><input type="text" class="inputConfig aidValue" id="aidValue_<?php echo $daysOfWeek->getId(); ?>" value="" style="display: none" disabled></td>
                                            <td>
                                                <div class="buttonItemsBox config">
                                                    <div class="buttonsItems config">
                                                        <span><i value="<?php echo $daysOfWeek->getParamValue(); ?>" id="<?php echo $daysOfWeek->getId(); ?>" class="icon-pencil icondDaysOfWeek"></i></span>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td id="paramName_<?php echo $timeStart->getId(); ?>"><?php echo $timeStart->getParamName(); ?></td>
                                            <td><input type="text" class="inputConfig" id="paramValue_<?php echo $timeStart->getId(); ?>" value="<?php echo $timeStart->getParamValue(); ?>" placeholder="np: 08:00" disabled></td>
                                            <td><input type="text" class="inputConfig aidValue" id="aidValue_<?php echo $timeStart->getId(); ?>" value="<?php echo $timeStart->getAidValue(); ?>" disabled></td>
                                            <td>
                                                <div class="buttonItemsBox config">
                                                    <div class="buttonsItems config">
                                                        <span><i id="<?php echo $timeStart->getId(); ?>" class="icon-pencil"></i></span>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td id="paramName_<?php echo $timeEnd->getId(); ?>"><?php echo $timeEnd->getParamName(); ?></td>
                                            <td><input type="text" class="inputConfig" id="paramValue_<?php echo $timeEnd->getId(); ?>" value="<?php echo $timeEnd->getParamValue(); ?>" placeholder="np: 18:00" disabled></td>
                                            <td><input type="text" class="inputConfig aidValue" id="aidValue_<?php echo $timeEnd->getId(); ?>" value="<?php echo $timeEnd->getAidValue(); ?>" disabled></td>
                                            <td>
                                                <div class="buttonItemsBox config">
                                                    <div class="buttonsItems config">
                                                        <span><i id="<?php echo $timeEnd->getId(); ?>" class="icon-pencil"></i></span>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="row">
                        <div class="medium-6 columns">
                            <?php if ($view['security']->isGranted('ROLE_NEWSLETTER_EDIT')): ?>

                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="large-6 columns">
            <!--SENDERS LIST-->
            <div class="box collapsed-box">
                <div class="box-header bg-transparent">
                    <!-- tools box -->
                    <div class="pull-right box-tools">
                        <span class="box-btn" data-toggle="configNews-dropdown2">
                            <i class="icon-cog-5"></i>
                        </span>
                        <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configNews-dropdown2" data-dropdown data-close-on-click="true">
                            <ul class="no-bullet">
                                <?php if ($view['security']->isGranted('ROLE_NEWSLETTER_EDIT')): ?>
                                    <li>
                                        <a href="<?php echo $view['router']->path('wi_admin_newsletter_senders_new'); ?>"  title="<?php echo $view['translator']->trans('newsletter.blockContent.senders.new'); ?>">
                                            <span><i class="icon-folder-add"></i><?php echo $view['translator']->trans('newsletter.blockContent.senders.new'); ?></span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </div>
                        <span>
                            <i class="icon-up-open collapseExpand" data-widget="collapse"></i>
                        </span>
                    </div>
                    <h3 class="box-title" data-widget="collapse"><i class="icon-help-circled"></i>
                        <span><?php echo $view['translator']->trans('newsletter.blocks.senders'); ?></span>
                    </h3>
                </div>
                <!-- /.box-body -->
                <div class="box-body " style="display: none;">
                    <div class="row">
                        <div class="medium-6 columns ">
                            <?php if ($view['security']->isGranted('ROLE_NEWSLETTER_EDIT')): ?>

                            <?php endif; ?>
                        </div>
                        <div class="columns end tableResp">
                            <table id="sendersList" class="tableResp" style="width:100%">
                                <thead>
                                    <tr>
                                        <th><?php echo $view['translator']->trans('newsletter.blockContent.senders.email'); ?></th>
                                        <th><?php echo $view['translator']->trans('newsletter.blockContent.senders.name'); ?></th>
                                        <th class="langStyle"><?php echo $view['translator']->trans('newsletter.blockContent.senders.counter'); ?></th>
                                        <th class="langStyle"><?php echo $view['translator']->trans('newsletter.blockContent.senders.language'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php foreach ($senders as $sender): ?>
                                    <tr>
                                        <td><a href="<?php echo $view['router']->path('wi_admin_newsletter_senders_edit', ['id' => $sender->getId()]); ?>" class=""><?php echo $sender->getEmail(); ?></a></td>
                                        <td><?php echo $sender->getName(); ?></td>
                                        <td class="langStyle">
                                            <?php echo $sendedMessages->filter(function ($entry) use ($sender) {
                                                return $entry->getSender()->getId() === $sender->getId();
                                            })->count(); ?>
                                        </td>
                                        <td class="langStyle"><?php echo $sender->getLang(); ?></td>
                                    </tr>
                                <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="row">
                        <div class="medium-6 columns">
                            <?php if ($view['security']->isGranted('ROLE_NEWSLETTER_EDIT')): ?>

                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="large-12 columns">
            <!--CAMPAIGN-->
            <div class="box collapsed-box">
                <div class="box-header bg-transparent">
                    <!-- tools box -->
                    <div class="pull-right box-tools">
                        <span class="box-btn" data-toggle="configNews-dropdown3">
                            <i class="icon-cog-5"></i>
                        </span>
                        <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configNews-dropdown3" data-dropdown data-close-on-click="true">
                            <ul class="no-bullet">
                                <?php if ($view['security']->isGranted('ROLE_NEWSLETTER_EDIT')): ?>
                                    <li>
                                        <a href="<?php echo $view['router']->path('wi_admin_newsletter_campaign_new'); ?>"  title="<?php echo $view['translator']->trans('blockList.addNewBlock'); ?>">
                                            <span><i class="icon-folder-add"></i><?php echo $view['translator']->trans('newsletter.blockContent.campaign.newCampaign'); ?></span>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="<?php echo $view['router']->path('wi_admin_newsletter_messagecontent_new', ["id" => $currentCampaign->getParamValue()]); ?>" title="<?php echo $view['translator']->trans('newsletter.blockContent.campaign.newMessageCurrent'); ?>">
                                            <span><i class="icon-folder-add"></i><?php echo $view['translator']->trans('newsletter.blockContent.campaign.newMessageCurrent'); ?></span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </div>
                        <div class="pull-right box-tools">
                            <span>
                                <i class="icon-up-open collapseExpand" data-widget="collapse"></i>
                            </span>
                        </div>
                    </div>
                    <h3 class="box-title" data-widget="collapse"><i class="icon-help-circled"></i>
                        <span><?php echo $view['translator']->trans('newsletter.blocks.campaign'); ?></span>
                    </h3>
                </div>
                <div class="box-body " style="display: none;">
                    <div class="row">
                        <div class="large-6 columns tableResp">
                            <table id="campaignsInfo" class="tableResp" style="width:100%">
                                <caption><?php echo $view['translator']->trans('newsletter.blockContent.campaign.list'); ?></caption>
                                <thead>
                                    <tr>
                                        <th><?php echo $view['translator']->trans('newsletter.blockContent.campaign.id'); ?></th>
                                        <th><?php echo $view['translator']->trans('newsletter.blockContent.campaign.name'); ?></th>
                                        <th class="langStyle"><?php echo $view['translator']->trans('newsletter.blockContent.campaign.counter'); ?></th>
                                        <th class="langStyle"><?php echo $view['translator']->trans('newsletter.blockContent.campaign.message'); ?></th>
                                        <th><?php echo $view['translator']->trans('newsletter.blockContent.campaign.expiryDate'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php foreach ($campaigns as $campaign): ?>
                                    <tr>
                                        <td><?php echo $campaign->getId(); ?></td>
                                        <td>
                                            <a href="<?php echo $view['router']->path('wi_admin_newsletter_campaign_show', ['id' => $campaign->getId()]); ?>">
                                                <?php echo $campaign->getName() . ($campaign === $activeCampaign ? '<span style="color: green"> (Active)</span>' : null) ?>
                                            </a>
                                        </td>
                                        <td class="langStyle"><?php echo $campaign->getSendMessagesCount(); ?></td>
                                        <td class="langStyle"><?php echo $campaign->getMessageContent()->count(); ?></td>
                                        <td><?php echo $campaign->getDateExpired()->format('Y-m-d'); ?></td>
                                    </tr>
                                <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="large-6 columns tableResp">
                            <table id="campaignInfo" class="tableResp" style="width:100%">
                                <caption><?php echo $view['translator']->trans('newsletter.blockContent.campaign.content'); ?> - <?php echo $infoTab[6]; ?></caption>
                                <thead>
                                    <tr>
                                        <th class="langStyle"><?php echo $view['translator']->trans('newsletter.blockContent.campaign.id'); ?></th>
                                        <th class="langStyle"><?php echo $view['translator']->trans('newsletter.blockContent.campaign.lang'); ?></th>
                                        <th><?php echo $view['translator']->trans('newsletter.blockContent.campaign.messageTitle'); ?></th>
                                        <th class="langStyle"><?php echo $view['translator']->trans('newsletter.blockContent.campaign.counter'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php foreach ($activeCampaign->getMessageContent() as $messageContent): ?>
                                    <tr>
                                        <td class="langStyle"><?php echo $messageContent->getId(); ?></td>
                                        <td class="langStyle"><?php echo $messageContent->getLang(); ?></td>
                                        <td><a href="<?php echo $view['router']->path('wi_admin_newsletter_messagecontent_edit', ['id' => $messageContent->getId()]); ?>" class=""><?php echo $messageContent->getTitle(); ?></a></td>
                                        <td class="langStyle">
                                            <?php echo $sendedMessages->filter(function ($entry) use ($messageContent) {
                                                return $entry->getMessageContent()->getId() === $messageContent->getId();
                                            })->count(); ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!--LOGS-->
<div class="box">
    <div class="box-header bg-transparent">
        <div class="pull-right box-tools">
            <span><i class="icon-up-open collapseExpand" data-widget="collapse"></i></span>
        </div>
        <h3 class="box-title" data-widget="collapse"><i class="icon-help-circled"></i>
            <span><?php echo $view['translator']->trans('newsletter.blocks.logs'); ?></span>
        </h3>
    </div>
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="columns end tableResp">
                <table id="logsInfo" class="tableResp" style="width:100%">
                    <thead>
                    <tr>
                        <th><?php echo $view['translator']->trans('newsletter.blockContent.logs.date'); ?></th>
                        <th><?php echo $view['translator']->trans('newsletter.blockContent.logs.recipient'); ?></th>
                        <th><?php echo $view['translator']->trans('newsletter.blockContent.logs.sender'); ?></th>
                        <th><?php echo $view['translator']->trans('newsletter.blockContent.logs.campaign'); ?></th>
                        <th><?php echo $view['translator']->trans('newsletter.blockContent.logs.message'); ?></th>
                        <th><?php echo $view['translator']->trans('newsletter.blockContent.logs.status'); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($logs as $log): ?>
                        <tr>
                            <td style="padding-left: 10px !important; white-space: nowrap;"><a href="<?php echo $view['router']->path('wi_admin_newsletter_logs_show', ['id' => $log->getId()]) ?>" class=""><?php echo $log->getDateMessage()->format('Y-m-d H:i:s'); ?></a></td>
                            <td><?php echo ($recipient = $log->getRecipient()) ? $recipient->getEmail().' ['.$recipient->getLang().']' : null; ?></td>
                            <td><?php echo ($sender = $log->getSender()) ? $sender->getEmail().' ['.$sender->getLang().']' : null; ?></td>
                            <td><?php echo ($campaign = $log->getCampaign()) ? $campaign->getName() : null; ?></td>
                            <td><?php echo ($messageContent = $log->getMessageContent()) ? $messageContent->getTitle().' ['.$messageContent->getLang().']' : null; ?></td>
                            <td class="langStyle"><?php echo $log->getStatus(); ?></td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="row">
            <div class="medium-12 columns paginationBox">
                <?php echo $view->render('KnpPaginatorBundle/Pagination/per_page_logs.html.php', [
                    'knp_pagination' => $logs,
                ]); ?>

                <?php echo $view['knp_pagination']->render($logs); ?>
            </div>
        </div>
    </div>
</div>

<script>
    var language = '<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/i18n/'.$view['request']->getLocale().'.json'); ?>';
</script>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
    <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js'); ?>"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/jquery.tooltipster.min.js'); ?>"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/chosen/chosen.jquery.min.js'); ?>"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/date-dropdown/jquery.datetimepicker.js'); ?>"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/newsletter.js'); ?>"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/newsletter-statistics.js'); ?>"></script>
<?php $view['slots']->stop(); ?>

