<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_faq_question_index')); ?>

<?php $view['slots']->set('title', 'WiCMS v3 - Newsletter - Kampania - Szczegóły'); ?>

<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/chosen/chosen.min.css') ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css'); ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css'); ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/newsletter.css'); ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li><a href="<?php echo $view['router']->path('wi_admin_newsletter_index'); ?>">Newsletter</a></li>
<li><a href="<?php echo $view['router']->path('wi_admin_newsletter_campaign_index', ['id' => $campaign->getId()]); ?>">Campaign</a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
<i class="icon-mail"></i>Campaign - Summary - <?php echo $campaign->getName(); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleDesc'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
<div class="row">
    <!-- Status -->
    <?php echo $view->render('WiAdminNewsLetterBundle:Campaign:Components/status.html.php', [
        'campaign' => $campaign,
        'statistics' => $statistics,
    ]); ?>
    <!-- Statystyki -->
    <?php echo $view->render('WiAdminNewsLetterBundle:Campaign:Components/statistics.html.php'); ?>
</div>

<div class="box configS">
    <h3><span><?php echo $view['translator']->trans('newsletter.blockContent.config.settings'); ?></span></h3>
    <div class="row">
        <!-- Ustawienia -->
        <?php echo $view->render('WiAdminNewsLetterBundle:Campaign:Components/settings.html.php', [
            'campaign' => $campaign,
            'config' => $config,
        ]); ?>
        <?php echo $view->render('WiAdminNewsLetterBundle:Campaign:Components/senders.html.php', [
            'addSenderForm' => $addSenderForm,
            'campaign' => $campaign,
            'sendersSendedCount' => $sendersSendedCount,
        ]); ?>
    </div>
    <div class="row">
        <!-- Wiadomości -->
        <?php echo $view->render('WiAdminNewsLetterBundle:Campaign:Components/messages.html.php', [
            'campaign' => $campaign,
            'messageSendedCount' => $messageSendedCount,
        ]); ?>
        <!-- Grupy odbiorców -->
        <?php echo $view->render('WiAdminNewsLetterBundle:Campaign:Components/recipient_groups.html.php', [
            'addGroupForm' => $addGroupForm,
            'campaign' => $campaign,
        ]); ?>
    </div>
</div>

<!-- Logi -->
<?php echo $view->render('WiAdminNewsLetterBundle:Campaign:Components/logs.html.php', [
    'logs' => $logs,
]); ?>

<div class="row">
    <div class="large-2 columns"></div>
    <div class="large-10 columns">
        <div class="news-add-form">
            <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_newsletter_index'); ?>">
                <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.back'); ?>
            </a>
        </div>
    </div>
</div>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script>
    var language = '<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/i18n/'.$view['request']->getLocale().'.json'); ?>';
    var campaign_id =  <?php echo $campaign->getId(); ?>;
</script>
<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/jquery.tooltipster.min.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/chosen/chosen.jquery.min.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/date-dropdown/jquery.datetimepicker.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/newsletter2.js?v=3'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/newsletter-statistics.js'); ?>"></script>
<?php $view['slots']->stop(); ?>

