<?php

namespace Wi\Admin\NewsLetterBundle\Repository;

use Doctrine\ORM\EntityRepository;
use Wi\Admin\NewsLetterBundle\Entity\Campaign;

/**
 * SendersRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class SendersRepository extends EntityRepository
{
    /**
     * Pobiera wszystkie aktywne pytania.
     *
     * @return array
     */
    public function findAllActive()
    {
        return $this->createQueryBuilder('q')
            ->where('q.status = :status')
            ->andWhere('q.dateDeleted IS NULL')
            ->setParameters([
                'status' => 'A',
            ])
            ->orderBy('q.email', 'ASC')
            ->addOrderBy('q.name', 'ASC')
            ->getQuery()
            ->getResult()
        ;
    }

    /**
     * Pobranie nadawcy na podstawie języka. Jeśli jest wybrana opcja losowa,
     * to zwraca losowego nadawcę dla danego języka.
     *
     * @param string $lang
     * @param bool $random
     * @return Senders|null
     */
    public function findSenderByLang($lang, $random = false)
    {
        $qb = $this->createQueryBuilder('s')
            ->where('s.lang = :lang')
        ;

        if ($random) {
            $qb->orderBy('RAND()');
        }

        return $qb
            ->setParameters([
                'lang' => $lang,
            ])
            ->setMaxResults(1)
            ->getQuery()
            ->getOneOrNullResult()
        ;
    }

    public function findSenderByCampaign(Campaign $campaign, $random = false)
    {
        $qb = $this->createQueryBuilder('s')
            ->leftJoin('s.campaigns', 'c')
            ->where('c.id = :campaign')
        ;

        if ($random) {
            $qb->orderBy('RAND()');
        }

        return $qb
            ->setParameters([
                'campaign' => $campaign->getId()
            ])
            ->setMaxResults(1)
            ->getQuery()
            ->getOneOrNullResult()
        ;
    }
}
