<?php

namespace Wi\Admin\NewsLetterBundle\Repository;

/**
 * CampaignRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class CampaignRepository extends \Doctrine\ORM\EntityRepository
{
    /**
     * Pobiera wszystkie aktywne pytania.
     *
     * @return array
     */
    public function findAllActive()
    {
        return $this->createQueryBuilder('q')
            ->where('q.status = :status')
            ->andWhere('q.dateDeleted IS NULL')
            ->setParameters([
                'status' => 'A',
            ])
            ->orderBy('q.dateCreated', 'DESC')
            ->getQuery()
            ->getResult()
        ;
    }

    /**
     * Pobiera wszystkie aktywne kampanie.
     *
     * @return array
     */
    public function getFindAllActive()
    {
        return $this->createQueryBuilder('c')
            ->addSelect('cc')
            ->leftJoin('c.config', 'cc')
            ->where('cc.paramName = :paramName')
            ->andWhere('cc.dateDeleted IS NULL')
            ->andWhere('cc.paramValue = :paramValue')
            ->setParameters([
                'paramName' => 'enable_campaign',
                'paramValue' => 1,
            ])
            ->orderBy('c.dateExpired', 'DESC')
            ->getQuery()
            ->getResult()
        ;
    }

    /**
     * Zapytanie dla wszystkich nieaktywnych kampanii.
     *
     * @return Query
     */
    public function getFindAllNotActiveQuery()
    {
        return $this->createQueryBuilder('c')
            ->addSelect('cc')
            ->leftJoin('c.config', 'cc')
            ->where('cc.paramName = :paramName')
            ->andWhere('cc.dateDeleted IS NULL')
            ->andWhere('cc.paramValue = :paramValue')
            ->setParameters([
                'paramName' => 'enable_campaign',
                'paramValue' => 0,
            ])
            ->orderBy('c.dateExpired', 'DESC')
            ->getQuery()
        ;
    }
}
