<?php

namespace Wi\Admin\NewsLetterBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;

class SendersType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('email', TextType::class, [
                'attr' => [
                    'maxlength' => 128,
                ],
            ])
            ->add('name', TextType::class, [
                'attr' => [
                    'maxlength' => 64,
                ],
                'required' => false,
            ])
            ->add('replayTo', TextType::class, [
                'attr' => [
                    'maxlength' => 64,
                ],
                'required' => false,
            ])
            ->add('smtpLogin', TextType::class, [
                'attr' => [
                    'maxlength' => 45,
                ],
            ])
            ->add('smtpPassword', TextType::class, [
                'attr' => [
                    'maxlength' => 128,
                ],
            ])
            ->add('smtpHost', TextType::class, [
                'attr' => [
                    'maxlength' => 128,
                ],
            ])
            ->add('smtpSsl', TextType::class, [
                'attr' => [
                    'maxlength' => 45,
                ],
            ])
            ->add('smtpPort', TextType::class, [
                'attr' => [
                ],
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'Wi\Admin\NewsLetterBundle\Entity\Senders'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'wi_admin_newsletterbundle_senders';
    }


}
