<?php

namespace Wi\Admin\NewsLetterBundle\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Symfony\Component\Validator\Constraints as Assert;
use Wi\Admin\NewsLetterBundle\Entity\Campaign;

/**
 * Senders
 *
 * @author Maksymilian Baryczka <mmaxioo33@gmail.com>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 *
 * @ORM\Table(name="newsletter_senders")
 * @ORM\Entity(repositoryClass="Wi\Admin\NewsLetterBundle\Repository\SendersRepository")
 * @ORM\EntityListeners({"Wi\Admin\NewsLetterBundle\EventListener\Entity\SendersListener"})
 * @ORM\HasLifecycleCallbacks()
 * @Gedmo\SoftDeleteable(fieldName = "dateDeleted")
 */
class Senders
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="email", type="string", length=128, unique=true)
     * @Assert\NotBlank()
     */
    private $email;

    /**
     * @var string
     *
     * @ORM\Column(name="smtp_login", type="string", length=45)
     * @Assert\NotBlank()
     */
    private $smtpLogin;

    /**
     * @var string
     *
     * @ORM\Column(name="smtp_password", type="string", length=128)
     * @Assert\NotBlank()
     */
    private $smtpPassword;

    /**
     * @var string
     *
     * @ORM\Column(name="smtp_host", type="string", length=128)
     * @Assert\NotBlank()
     */
    private $smtpHost;

    /**
     * @var string
     *
     * @ORM\Column(name="smtp_ssl", type="string", length=45)
     * @Assert\NotBlank()
     */
    private $smtpSsl;

    /**
     * @var int
     *
     * @ORM\Column(name="smtp_port", type="integer")
     * @Assert\NotBlank()
     */
    private $smtpPort;

    /**
     * @var string
     *
     * @ORM\Column(name="replay_to", type="string", length=64, nullable=true)
     */
    private $replayTo;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=64, nullable=true)
     */
    private $name;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime")
     */
    private $dateCreated;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_deleted", type="datetime", nullable=true)
     */
    private $dateDeleted;

    /**
     * @var string
     *
     * @ORM\Column(name="status", type="string", length=1, options={"default": "A", "fixed" = true})
     */
    private $status;

    /**
     * @var ArrayCollection
     *
     * @ORM\ManyToMany(targetEntity="Wi\Admin\NewsLetterBundle\Entity\Campaign", mappedBy="senders")
     */
    private $campaigns;


    // ------------------------------------------------------------
    // Has Lifecycle Callbacks methods.
    // ------------------------------------------------------------

    /**
     * Funkcja wykonuje się podczas wstawiania nowego rekordu do bazy.
     *
     * @ORM\PrePersist
     */
    public function prePersist()
    {
        // Ustawienie daty utworzenia.
        $this->dateCreated = new \DateTime();

        // Ustawienie statusu.
        if (is_null($this->status)) {
            $this->status = 'A';
        }
    }

    // ------------------------------------------------------------
    // Getters and setters methods.
    // ------------------------------------------------------------

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set email
     *
     * @param string $email
     * @return Senders
     */
    public function setEmail($email)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * Get email
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Set smtpLogin
     *
     * @param string $smtpLogin
     * @return Senders
     */
    public function setSmtpLogin($smtpLogin)
    {
        $this->smtpLogin = $smtpLogin;

        return $this;
    }

    /**
     * Get smtpLogin
     *
     * @return string
     */
    public function getSmtpLogin()
    {
        return $this->smtpLogin;
    }

    /**
     * Set smtpPassword
     *
     * @param string $smtpPassword
     * @return Senders
     */
    public function setSmtpPassword($smtpPassword)
    {
        $this->smtpPassword = $smtpPassword;

        return $this;
    }

    /**
     * Get smtpPassword
     *
     * @return string
     */
    public function getSmtpPassword()
    {
        return $this->smtpPassword;
    }

    /**
     * Set smtpHost
     *
     * @param string $smtpHost
     * @return Senders
     */
    public function setSmtpHost($smtpHost)
    {
        $this->smtpHost = $smtpHost;

        return $this;
    }

    /**
     * Get smtpHost
     *
     * @return string
     */
    public function getSmtpHost()
    {
        return $this->smtpHost;
    }

    /**
     * Set smtpSsl
     *
     * @param string $smtpSsl
     * @return Senders
     */
    public function setSmtpSsl($smtpSsl)
    {
        $this->smtpSsl = $smtpSsl;

        return $this;
    }

    /**
     * Get smtpSsl
     *
     * @return string
     */
    public function getSmtpSsl()
    {
        return $this->smtpSsl;
    }

    /**
     * Set smtpPort
     *
     * @param integer $smtpPort
     * @return Senders
     */
    public function setSmtpPort($smtpPort)
    {
        $this->smtpPort = $smtpPort;

        return $this;
    }

    /**
     * Get smtpPort
     *
     * @return int
     */
    public function getSmtpPort()
    {
        return $this->smtpPort;
    }

    /**
     * Set replayTo
     *
     * @param string $replayTo
     * @return Senders
     */
    public function setReplayTo($replayTo)
    {
        $this->replayTo = $replayTo;

        return $this;
    }

    /**
     * Get replayTo
     *
     * @return string
     */
    public function getReplayTo()
    {
        return $this->replayTo;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return Senders
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     * @return Senders
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set dateDeleted
     *
     * @param \DateTime $dateDeleted
     * @return Senders
     */
    public function setDateDeleted($dateDeleted)
    {
        $this->dateDeleted = $dateDeleted;

        return $this;
    }

    /**
     * Get dateDeleted
     *
     * @return \DateTime
     */
    public function getDateDeleted()
    {
        return $this->dateDeleted;
    }

    /**
     * Set status
     *
     * @param string $status
     * @return Senders
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get status
     *
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Add campaign
     *
     * @param Campaign $campaign
     * @return Senders
     */
    public function addCampaign(Campaign $campaign)
    {
        $this->campaigns[] = $campaign;

        return $this;
    }

    /**
     * Remove campaign
     *
     * @param Campaign $campaign
     */
    public function removeCampaign(Campaign $campaign)
    {
        $this->campaigns->removeElement($campaign);
    }

    /**
     * Get campaigns
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getCampaigns()
    {
        return $this->campaigns;
    }

    // ------------------------------------------------------------
    // Methods.
    // ------------------------------------------------------------

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->campaigns = new ArrayCollection();
    }

    /**
     * Get replyTo
     *
     * @return string
     */
    public function getReplyTo()
    {
        return $this->replayTo;
    }

    // ------------------------------------------------------------
    // Deprecations.
    // ------------------------------------------------------------

    /**
     * Set lang
     *
     * @param string $lang
     * @return Senders
     */
    public function setLang($lang)
    {
        $this->lang = $lang;

        return $this;
    }

    /**
     * Get lang
     *
     * @return string
     */
    public function getLang()
    {
        return;
    }
}
