<?php

namespace Wi\Admin\NewsLetterBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Doctrine\ORM\Mapping\ClassMetadata;
use Wi\Admin\NewsLetterBundle\Entity\Config;

/**
 * Załadowanie ustawień newslettera do bazy danych.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2018 WEBimpuls Sp. z o.o.
 */
class LoadNewsletterConfigData extends AbstractFixture implements OrderedFixtureInterface
{
    /**
     * {@inheritdoc}
     */
    public function load(ObjectManager $manager)
    {
        foreach ($this->getData() as $data) {
            $config = $this->getConfig($data);

            // Przygotowanie do zapisu.
            $manager->persist($config);

            // Wymuszenie podania ID.
            $metadata = $manager->getClassMetaData(get_class($config));
            $metadata->setIdGeneratorType(ClassMetadata::GENERATOR_TYPE_NONE);
        }

        // Zapis.
        $manager->flush();
    }

    /**
     * {@inheritdoc}
     */
    public function getOrder()
    {
        return 61;
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Tablica danych.
     *
     * @return mixed[]
     */
    private function getData()
    {
        return [
            ['id' => 1, 'paramName' => 'enable_newsletter', 'paramValue' => 0, 'aidValue' => null],
        ];
    }

    /**
     * Tworzy obiekt nowego wpisu konfiguracji na podstawie przekazanej
     * tablicy danych.
     *
     * @param   array $data
     * @return  \Wi\Admin\CoreBundle\Entity\Config
     */
    private function getConfig(array $data)
    {
        return (new Config())
            ->setId($data['id'])
            ->setParamName($data['paramName'])
            ->setParamValue($data['paramValue'])
            ->setAidValue($data['aidValue'])
        ;
    }
}
